/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging.dialog;

import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;
import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.MessageListener;
import javax.swing.JTextField;

public class StatusBarMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger((Class)StatusBarMessageListener.class);
    private JTextField textField;
    private static final int CLEANUP_INVERVAL = 5000;
    private Thread cleaner;

    public StatusBarMessageListener(JTextField statusTextField) {
        this.textField = statusTextField;
    }

    public void displayMessage(MessageEvent e) {
        Message message = e.getMessage();
        if (!message.getType().equals("DISPLAY")) {
            return;
        }
        if (this.cleaner != null && this.cleaner.isAlive()) {
            this.cleaner.interrupt();
            try {
                this.cleaner.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.textField.setText(e.getMessage().getTitleText());
        this.textField.validate();
        this.cleaner = new StatusBarCleaner();
        this.cleaner.setDaemon(true);
        this.cleaner.start();
    }

    private class StatusBarCleaner
    extends Thread {
        StatusBarCleaner() {
            super("Status bar cleaner");
        }

        public void run() {
            try {
                try {
                    StatusBarCleaner.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    StatusBarMessageListener.this.textField.setText("");
                }
                catch (Throwable t) {
                    log.error("Couldn't clean status text.", t);
                }
            }
            catch (ThreadDeath td) {
                log.error("Status bar cleaner thread died.", (Throwable)td);
            }
        }
    }
}

