/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.messaging.dialog.DefaultTextResources;
import com.levigo.util.progress.DefaultProgressEventListener;
import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import com.levigo.util.swing.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class BlueLineProgressEventListener
extends DefaultProgressEventListener {
    private JFrame frame;
    private BlueLineProgressBar blPb;
    private JLabel noteLabel;
    static /* synthetic */ Class class$com$levigo$util$progress$BlueLineProgressEventListener;

    public BlueLineProgressEventListener(final ProgressSource source) {
        ProgressManager.getInstance().addProgressEventListener(this, source, "progressChanged|statusChanged");
        this.frame = new JFrame();
        int min = source.getProgress().getMinimum();
        int max = source.getProgress().getMaximum();
        int cur = source.getProgress().getValue();
        this.blPb = new BlueLineProgressBar(min, max, cur);
        this.frame.getContentPane().add((Component)this.blPb, "North");
        this.noteLabel = new JLabel(source.getProgress().getNote(), 0);
        this.frame.getContentPane().add((Component)this.noteLabel, "Center");
        if (source.canCancel()) {
            JButton cancelButton = new JButton(DefaultTextResources.getString("progress.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    source.cancel();
                }
            });
            this.frame.getContentPane().add((Component)cancelButton, "South");
        }
        this.frame.setTitle(source.getProgressSourceName());
        this.frame.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(screen.width / 2 - this.frame.getSize().width / 2, screen.height / 2 - this.frame.getSize().height / 2 - 50);
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void progressChanged(ProgressEvent e) {
        if (null != this.blPb) {
            if (e.getEventType().equals("progressChanged")) {
                this.blPb.setStepValue(e.getProgress().getValue());
                this.noteLabel.setText(e.getSource().getProgress().getNote());
            } else if (e.getStatus().equals("finished")) {
                this.dispose();
            } else if (e.getStatus().equals("aborted")) {
                this.dispose();
            } else if (e.getStatus().equals("cancelled")) {
                this.dispose();
            }
        }
    }

    private void dispose() {
        ProgressManager.getInstance().removeProgressEventListener(this);
        if (null != this.frame) {
            this.frame.dispose();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public class BlueLineProgressBar
    extends JComponent {
        private Image progressImage = IconManager.getInstance(class$com$levigo$util$progress$BlueLineProgressEventListener == null ? (class$com$levigo$util$progress$BlueLineProgressEventListener = BlueLineProgressEventListener.class$("com.levigo.util.progress.BlueLineProgressEventListener")) : class$com$levigo$util$progress$BlueLineProgressEventListener, "common-icons").getImage("progressBar");
        private Dimension prefSize = null;
        private int minValue = 0;
        private int maxValue = 100;
        private int stepValue = 0;
        private boolean isFinished = false;
        private static final String percentStr = " %";
        private static final String theEndStr = "Fertig";

        public BlueLineProgressBar() {
            this.setBackground(Color.lightGray);
            this.setEnabled(false);
            this.setImage();
        }

        public BlueLineProgressBar(int min, int max, int actValue) {
            this();
            this.setAllValues(min, max, actValue);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (this.progressImage == null || this.prefSize == null) {
                return this.getSize();
            }
            return this.prefSize;
        }

        public void makeAStep() {
            if (this.stepValue < this.maxValue) {
                if (++this.stepValue == this.maxValue) {
                    this.isFinished = true;
                }
                this.repaint();
            }
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            int emptyArea = d.width / 5;
            d.width -= emptyArea;
            int aQuarter = d.width / 4;
            g.setColor((Color)UIManager.get("Label.background"));
            int step = Math.round((float)this.stepValue * (1.0f * (float)d.width / (float)(this.maxValue - this.minValue)));
            if (this.progressImage != null) {
                g.drawImage(this.progressImage, 0, 5, this);
                g.fillRect(step, 4, d.width + emptyArea - step, d.height - 9);
            }
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, 0, d.height);
            g.drawLine(0, 0, 3, 0);
            g.drawLine(0, d.height - 1, 3, d.height - 1);
            g.drawLine(aQuarter, 0, aQuarter, d.height);
            g.drawLine(aQuarter * 2, 0, aQuarter * 2, d.height);
            g.drawLine(aQuarter * 3, 0, aQuarter * 3, d.height);
            g.drawLine(d.width, 0, d.width, d.height);
            g.drawLine(d.width, 0, d.width - 3, 0);
            g.drawLine(d.width, d.height - 1, d.width - 3, d.height - 1);
            g.setColor(Color.black);
            if (this.isFinished) {
                g.drawString(theEndStr, d.width + emptyArea / 2, d.height - 3);
            } else {
                int percent = 100 * (this.stepValue - this.minValue) / (this.maxValue - this.minValue);
                g.drawString(percent + percentStr, d.width + emptyArea / 2, d.height - 3);
            }
            super.paint(g);
        }

        public void setAllValues(int min, int max, int actValue) {
            if (min <= actValue && actValue <= max) {
                this.minValue = min;
                this.maxValue = max;
                this.stepValue = actValue;
                this.isFinished = actValue == max;
                this.repaint();
            }
        }

        private void setImage() {
            if (this.progressImage != null) {
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(this.progressImage, 0);
                try {
                    mt.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mt.removeImage(this.progressImage);
                mt = null;
                this.setSize(this.progressImage.getWidth(this), this.progressImage.getHeight(this) + 10);
                this.prefSize = this.getSize();
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }

        public void setStepValue(int step) {
            if (this.minValue <= step && step <= this.maxValue) {
                this.stepValue = step;
                this.isFinished = step == this.maxValue;
                this.repaint();
            }
        }
    }
}

