/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.messaging.dialog.DefaultTextResources;
import com.levigo.util.progress.DefaultProgressEventListener;
import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DefaultProgressDialog
extends DefaultProgressEventListener
implements ActionListener {
    private JProgressBar progressBar;
    private JDialog dialog;
    private JButton cancelButton;
    private JLabel label;
    private ProgressSource source;

    public DefaultProgressDialog(ProgressSource source, String labelText) {
        ProgressManager.getInstance().addProgressEventListener(this, source, "progressChanged|statusChanged");
        this.dialog = new JDialog();
        this.source = source;
        this.progressBar = source.getProgress().getProgressBar();
        this.label = new JLabel(labelText, 0);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel(layout);
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridheight = 1;
        constraints.gridwidth = 3;
        constraints.gridx = 1;
        constraints.gridy = 1;
        pane.add((Component)this.label, constraints);
        constraints.gridheight = 1;
        constraints.gridwidth = 3;
        constraints.gridx = 1;
        constraints.gridy = 2;
        JPanel progressPane = new JPanel();
        progressPane.add(this.progressBar);
        progressPane.setPreferredSize(new Dimension(160, 30));
        pane.add((Component)progressPane, constraints);
        if (source.canCancel()) {
            this.cancelButton = new JButton(DefaultTextResources.getString("progress.cancel"));
            this.cancelButton.addActionListener(this);
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 3;
            constraints.gridy = 3;
            constraints.fill = 0;
            constraints.weightx = 0.5;
            constraints.weighty = 0.5;
            constraints.anchor = 13;
            pane.add((Component)this.cancelButton, constraints);
        }
        this.dialog.getContentPane().add(pane);
        this.dialog.setSize(250, 130);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((screen.width - this.dialog.getSize().width) / 2, Math.max(50, (screen.height - this.dialog.getSize().height) / 2 - 50));
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getSource().toString());
        if (this.cancelButton == e.getSource()) {
            this.source.cancel();
        }
    }

    public void progressChanged(ProgressEvent e) {
        if (e.getStatus().equals("finished")) {
            if (null != this.dialog) {
                this.dialog.dispose();
            }
        } else if (e.getStatus().equals("aborted")) {
            if (null != this.dialog) {
                this.dialog.dispose();
            }
        } else if (e.getStatus().equals("cancelled")) {
            if (null != this.dialog) {
                this.dialog.dispose();
            }
        } else {
            this.label.setText(this.source.getProgress().getNote());
        }
        System.out.println("");
    }
}

