/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressEventListener;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressAndStatusBar
extends JPanel
implements ProgressEventListener {
    private JLabel noteLabel;
    private JDialog dialog;

    public ProgressAndStatusBar(ProgressSource source) {
        JPanel pane = new JPanel(new GridBagLayout());
        this.noteLabel = new JLabel(source.getProgress().getNote());
        JPanel progressPane = new JPanel();
        progressPane.add(new JProgressBar(source.getProgress().getModel()));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 17;
        pane.add((Component)this.noteLabel, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.anchor = 13;
        pane.add((Component)progressPane, c);
        this.getRootPane().add(pane);
        ProgressManager.getInstance().addProgressEventListener(this, source, "progressChanged|statusChanged");
        this.dialog = new JDialog();
        this.dialog.setContentPane(this);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void progressChanged(ProgressEvent e) {
        this.noteLabel.setText(e.getProgress().getNote());
        if (e.getStatus().equals("finished")) {
            this.noteLabel.setText("");
        }
    }
}

