/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressEventListener;
import com.levigo.util.progress.ProgressEventMulticaster;
import com.levigo.util.progress.ProgressSource;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ProgressManager
implements ProgressEventMulticaster {
    private Vector allListenerRelations = null;
    private static ProgressManager instance = null;
    private Map allSources = Collections.synchronizedMap(new Hashtable());

    private ProgressManager() {
        this.allListenerRelations = new Vector();
    }

    public void finalize() {
        System.err.println("finalizing...");
        instance = null;
        try {
            super.finalize();
        }
        catch (Throwable t) {
            System.err.println("Darn. Problem finalizing.");
        }
    }

    public static ProgressManager getInstance() {
        if (null != instance) {
            return instance;
        }
        instance = new ProgressManager();
        return instance;
    }

    public void progressChanged(ProgressEvent e) {
        this.fireProgressEvent(e);
    }

    public ProgressSource getProgressSource(String name) {
        return (ProgressSource)this.allSources.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressEventListener(ProgressEventListener listener, ProgressSource source, String type) {
        Vector vector = this.allListenerRelations;
        synchronized (vector) {
            ListenerContainer container = new ListenerContainer(listener, source, type);
            this.allListenerRelations.add(container);
        }
    }

    public void fireProgressEvent(ProgressEvent event) {
        ProgressSource source = event.getSource();
        String type = event.getEventType();
        ListenerContainer thisContainer = null;
        for (int i = 0; i < this.allListenerRelations.size(); ++i) {
            thisContainer = (ListenerContainer)this.allListenerRelations.get(i);
            if (thisContainer.typeOfProgressEvent == null && thisContainer.source == source) {
                thisContainer.listener.progressChanged(event);
                continue;
            }
            if (thisContainer.source == source && (thisContainer.typeOfProgressEvent.startsWith(type) || thisContainer.typeOfProgressEvent.endsWith(type))) {
                thisContainer.listener.progressChanged(event);
                continue;
            }
            if (thisContainer.source != null || thisContainer.typeOfProgressEvent != null && !thisContainer.typeOfProgressEvent.endsWith(type) && !thisContainer.typeOfProgressEvent.startsWith(type)) continue;
            thisContainer.listener.progressChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressEventListener(ProgressEventListener listener) {
        Vector vector = this.allListenerRelations;
        synchronized (vector) {
            ListenerContainer thisContainer = null;
            for (int i = 0; i < this.allListenerRelations.size(); ++i) {
                thisContainer = (ListenerContainer)this.allListenerRelations.get(i);
                if (thisContainer.listener != listener) continue;
                this.allListenerRelations.remove(i);
            }
        }
    }

    private class ListenerContainer {
        ProgressEventListener listener = null;
        ProgressSource source = null;
        String typeOfProgressEvent = null;

        ListenerContainer(ProgressEventListener listener, ProgressSource source, String typeOfProgressEvent) {
            this.listener = listener;
            this.source = source;
            this.typeOfProgressEvent = typeOfProgressEvent;
        }
    }
}

