/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressEventListener;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SharedProgressAndStatusBar
implements ProgressEventListener {
    private static JPanel pane = new JPanel();
    private JProgressBar bar = null;

    public SharedProgressAndStatusBar(ProgressSource source) {
        this.bar = new JProgressBar(source.getProgress().getModel());
        pane.removeAll();
        pane.add(this.bar);
        pane.revalidate();
        ProgressManager.getInstance().addProgressEventListener(this, source, "progressChanged|statusChanged");
    }

    public static JPanel getRepresentation() {
        return pane;
    }

    public void progressChanged(ProgressEvent e) {
        if (e.getStatus().equals("new") || e.getStatus().equals("inProgress")) {
            pane.removeAll();
            pane.add(this.bar);
            pane.revalidate();
            pane.setToolTipText(e.getProgress().getNote());
        } else {
            this.dispose();
        }
    }

    private void dispose() {
        ProgressManager.getInstance().removeProgressEventListener(this);
        pane.setToolTipText("");
        if (this.bar != null) {
            pane.removeAll();
        }
        pane.revalidate();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

