/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.preferences.PreferenceStore;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public abstract class AbstractGeometryFrame
extends JFrame {
    public static Image WINDOW_ICON = null;
    private static HashMap auxiliaryWindowIconMap = null;
    private static Set activeFrameRegistry = new HashSet();
    private static List frameZOrder = new LinkedList();
    private static PreferenceStore preferenceStore = null;
    private static Point DEFAULT_LOCATION = new Point(Toolkit.getDefaultToolkit().getScreenSize().width / 10, Toolkit.getDefaultToolkit().getScreenSize().width / 10);
    private static Dimension DEFAULT_SIZE = new Dimension(400, 400);
    private static int idCounter = 0;
    private static AbstractGeometryFrame recentlyFocusedFrame = null;
    private String autoFrameID = Integer.toString(idCounter++);
    private static WindowAdapter windowAdapter = new RecentlyFocusedWindowAdapter();

    public AbstractGeometryFrame(String title) {
        super(title);
        this.restoreGeometry();
        this.applyTooltipFix();
        this.setIconImage(WINDOW_ICON);
    }

    private void applyTooltipFix() {
        boolean vmCheck = false;
        try {
            vmCheck = Integer.parseInt(System.getProperty("java.version").substring(2, 3)) == 4;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (vmCheck) {
            Rectangle bounds = this.getBounds();
            this.setLocation(0, 0);
            this.pack();
            this.setResizable(false);
            this.setResizable(true);
            this.setBounds(bounds);
        }
    }

    protected Point getDefaultLocation() {
        return new Point(DEFAULT_LOCATION);
    }

    protected Dimension getDefaultSize() {
        return new Dimension(DEFAULT_SIZE);
    }

    public abstract void restoreGeometry();

    protected boolean isExistingFrameAt(Point p) {
        Collection allFrames = AbstractGeometryFrame.getActiveFrames();
        if (null != allFrames) {
            Point ref = new Point();
            Iterator iter = allFrames.iterator();
            while (iter.hasNext()) {
                AbstractGeometryFrame frame = (AbstractGeometryFrame)iter.next();
                if (!frame.getLocation(ref).equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void saveGeometry();

    public void show() {
        AbstractGeometryFrame.registerActiveFrame(this);
        this.addWindowListener(windowAdapter);
        super.show();
    }

    public void hide() {
        this.saveGeometry();
        AbstractGeometryFrame.deregisterActiveFrame(this);
        this.removeWindowListener(windowAdapter);
        super.hide();
    }

    public static Frame getRecentlyFocusedFrame() {
        return recentlyFocusedFrame;
    }

    private static synchronized void registerActiveFrame(AbstractGeometryFrame frame) {
        activeFrameRegistry.add(frame);
        AbstractGeometryFrame.frameIsActive(frame);
    }

    private static synchronized void deregisterActiveFrame(AbstractGeometryFrame frame) {
        activeFrameRegistry.remove(frame);
        frameZOrder.remove(frame);
    }

    private static synchronized void frameIsActive(AbstractGeometryFrame frame) {
        frameZOrder.remove(frame);
        frameZOrder.add(0, frame);
    }

    public static Collection getActiveFrames() {
        return new LinkedList(activeFrameRegistry);
    }

    public static Collection getActiveFramesinZOrder() {
        return new LinkedList(frameZOrder);
    }

    protected static Collection getActiveFrames(String frameType) {
        ArrayList resultSet = new ArrayList();
        Iterator iterator = activeFrameRegistry.iterator();
        while (iterator.hasNext()) {
            resultSet.add(iterator.next());
        }
        return resultSet;
    }

    protected static AbstractGeometryFrame getActiveFrame(String frameType, String frameID) {
        Iterator iterator = activeFrameRegistry.iterator();
        while (iterator.hasNext()) {
            AbstractGeometryFrame f = (AbstractGeometryFrame)iterator.next();
            if (!f.getFrameType().equals(frameType) || !f.getFrameID().equals(frameID)) continue;
            return f;
        }
        return null;
    }

    public static PreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    public static void setPreferenceStore(PreferenceStore preferenceStore) {
        AbstractGeometryFrame.preferenceStore = preferenceStore;
    }

    public static void setWindowIcon(Image image) {
        if (image == WINDOW_ICON) {
            return;
        }
        WINDOW_ICON = image;
        Iterator it = AbstractGeometryFrame.getActiveFrames().iterator();
        while (it.hasNext()) {
            ((JFrame)it.next()).setIconImage(WINDOW_ICON);
        }
    }

    public static void putAuxiliaryWindowIcon(String iconIdentifier, Image image) {
        if (iconIdentifier == null || image == null) {
            return;
        }
        if (auxiliaryWindowIconMap == null) {
            auxiliaryWindowIconMap = new HashMap();
        }
        auxiliaryWindowIconMap.put(iconIdentifier, image);
    }

    protected static Image getAuxiliaryWindowIcon(String iconIdentifier) {
        return auxiliaryWindowIconMap == null ? null : auxiliaryWindowIconMap.get(iconIdentifier);
    }

    protected static Image getWindowIcon() {
        return WINDOW_ICON;
    }

    public String getFrameID() {
        return this.autoFrameID;
    }

    public abstract String getFrameType();

    public static void setRecentlyFocusedFrame(AbstractGeometryFrame recentlyFocusedFrame) {
        AbstractGeometryFrame.recentlyFocusedFrame = recentlyFocusedFrame;
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 205) {
            AbstractGeometryFrame.frameIsActive(this);
        }
    }

    private static class RecentlyFocusedWindowAdapter
    extends WindowAdapter {
        private RecentlyFocusedWindowAdapter() {
        }

        public void windowActivated(WindowEvent e) {
            recentlyFocusedFrame = (AbstractGeometryFrame)e.getSource();
        }
    }
}

