/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.image.AlphaFilter;
import com.levigo.util.image.BrightnessFilter;
import com.levigo.util.image.ContrastFilter;
import com.levigo.util.image.ExtractFilter;
import com.levigo.util.image.GrayFilter;
import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;
import com.levigo.util.swing.LevigoIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;

public class IconManager {
    private static final Logger log = LoggerFactory.getLogger((Class)IconManager.class);
    private static String CONTEXT = "IconManager";
    private Image iconImage;
    private Hashtable effectImages = new Hashtable();
    private Properties props;
    private static Hashtable instances = new Hashtable();
    private static final Component component = new Label();
    private static final MediaTracker tracker = new MediaTracker(component);
    public static final int AUTO_DISABLE = 1;
    public static final int AUTO_ROLLOVER = 2;
    public static final int EFFECT_GRAY = 4;
    public static final int EFFECT_GRAY50P = 64;
    public static final int EFFECT_LIGHTER = 8;
    public static final int EFFECT_DARKER = 16;
    public static final int EFFECT_ALPHA50P = 32;
    public static final int EFFECT_MORECONTRAST = 128;
    private int autoDisableFlags = 140;
    private int autoRolloverFlags = 8;
    private int defaultEffects = 0;

    private IconManager() {
    }

    private IconManager(Properties props, Image iconImage) {
        this.props = props;
        this.iconImage = iconImage;
    }

    public static IconManager getInstance(Class loadClass, String iconSetName) {
        String setName;
        if (null == loadClass) {
            Class clazz = loadClass = IconManager.class;
        }
        if (!instances.containsKey(setName = loadClass.getPackage() + iconSetName)) {
            String resourcePath = IconManager.resolveName(loadClass, iconSetName);
            IconManager im = null;
            if (instances.containsKey(resourcePath)) {
                im = (IconManager)instances.get(resourcePath);
            } else {
                im = IconManager.createIconManager(loadClass, iconSetName);
                instances.put(resourcePath, im);
            }
            instances.put(setName, im);
        }
        return (IconManager)instances.get(setName);
    }

    private static IconManager createIconManager(Class loadClass, String iconSetName) {
        IconManager theInstance = null;
        try {
            InputStream is = null;
            String resourcePath = null;
            resourcePath = iconSetName.indexOf("../") >= 0 ? IconManager.resolveName(loadClass, iconSetName) : iconSetName;
            is = loadClass.getResourceAsStream(resourcePath + ".properties");
            if (null == is && null == (is = loadClass.getResourceAsStream((resourcePath = "/" + iconSetName) + ".properties"))) {
                throw new IOException("Icon set properties for " + iconSetName + "(" + loadClass.getName() + ") not found.");
            }
            Properties iconSetProps = new Properties();
            iconSetProps.load(is);
            String extension = iconSetProps.getProperty("extension", "png");
            Image iconImage = IconManager.createImages(loadClass, resourcePath, extension);
            theInstance = new IconManager(iconSetProps, iconImage);
        }
        catch (IOException e) {
            log.error("Can't load icon set for " + iconSetName + "(" + loadClass.getName() + "): ", (Throwable)e);
        }
        return theInstance;
    }

    private static String resolveName(Class ref, String name) {
        StringTokenizer tok;
        Vector<String> pathComponents = new Vector<String>();
        if (!name.startsWith("/")) {
            String packageName = ref.getPackage().getName();
            tok = new StringTokenizer(packageName, ".");
            while (tok.hasMoreTokens()) {
                pathComponents.addElement(tok.nextToken());
            }
        }
        tok = new StringTokenizer(name, "/");
        while (tok.hasMoreTokens()) {
            pathComponents.addElement(tok.nextToken());
        }
        for (int i = 0; i < pathComponents.size(); ++i) {
            if (((String)pathComponents.get(i)).equals("..") && i >= 1) {
                pathComponents.removeElementAt(i);
                pathComponents.removeElementAt(i - 1);
                i -= 2;
            }
            if (!((String)pathComponents.get(i)).equals(".")) continue;
            pathComponents.removeElementAt(i);
        }
        StringBuffer res = new StringBuffer();
        Enumeration iterator = pathComponents.elements();
        while (iterator.hasMoreElements()) {
            res.append("/");
            res.append((String)iterator.nextElement());
        }
        return res.toString();
    }

    private static Image createImages(Class loadClass, String resourcePath, String extension) throws IOException {
        Image iconImage = null;
        InputStream is = loadClass.getResourceAsStream(resourcePath + "." + extension);
        if (null == is) {
            throw new IOException("InputStream was null");
        }
        iconImage = IconManager.loadNativeImage(is);
        if (null == iconImage) {
            throw new IOException("Image was null");
        }
        IconManager.mediaTrackerImage(iconImage);
        return iconImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int mediaTrackerImage(Image iconImage) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(iconImage, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while loading an image.");
            }
            int status = tracker.statusID(0, true);
            tracker.removeImage(iconImage, 0);
            return status;
        }
    }

    private static final Image loadNativeImage(InputStream is) throws IOException {
        int n;
        BufferedInputStream in = new BufferedInputStream(is);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.flush();
        buffer = out.toByteArray();
        if (buffer.length == 0) {
            throw new IOException("image has zero-length");
        }
        Image theImage = Toolkit.getDefaultToolkit().createImage(buffer);
        if (null == theImage) {
            throw new IOException("Image was null");
        }
        if (IconManager.mediaTrackerImage(theImage) != 8) {
            return null;
        }
        return theImage;
    }

    public Icon getIcon(String name) {
        return this.getIcon(name, this.defaultEffects);
    }

    public LevigoIcon getLevigoIcon(String name) {
        Rectangle[] iconRectangle = this.getIconRectangle(name);
        if (null != iconRectangle) {
            return new IconManagerLevigoIcon(iconRectangle, this.defaultEffects, null);
        }
        return null;
    }

    public LevigoIcon getCompositeLevigoIcon(String[] layers, int effectFlags, Dimension targetSize) {
        return new IconManagerLevigoIcon(this.getRectangles(layers), effectFlags, targetSize);
    }

    public Icon getIcon(String name, int effectFlags) {
        return this.getIcon(name, effectFlags, null);
    }

    public Icon getIcon(String name, int effectFlags, Dimension targetSize) {
        Rectangle[] iconRectangle = this.getIconRectangle(name);
        if (null != iconRectangle) {
            return new IconManagerIcon(iconRectangle, effectFlags, targetSize);
        }
        return null;
    }

    public Icon getCompositeIcon(String[] layers, int effectFlags, Dimension targetSize) {
        return new IconManagerIcon(this.getRectangles(layers), effectFlags, targetSize);
    }

    private Rectangle[] getRectangles(String[] layers) {
        ArrayList<Rectangle> iconRectangleList = new ArrayList<Rectangle>();
        for (int i = 0; i < layers.length; ++i) {
            Rectangle[] iconRectangles;
            if (null == layers[i] || null == (iconRectangles = this.getIconRectangle(layers[i]))) continue;
            for (int k = 0; k < iconRectangles.length; ++k) {
                if (null == iconRectangles[k]) continue;
                iconRectangleList.add(iconRectangles[k]);
            }
        }
        Rectangle[] iconRectangles = new Rectangle[iconRectangleList.size()];
        iconRectangleList.toArray(iconRectangles);
        return iconRectangles;
    }

    public Icon getCompositeIcon(String[] layers) {
        return this.getCompositeIcon(layers, this.defaultEffects, null);
    }

    public Image getImage(String name, int effectFlags) {
        Rectangle[] iconRectangle = this.getIconRectangle(name);
        Image image = null;
        if (null != iconRectangle && iconRectangle.length > 0) {
            if (iconRectangle.length != 1) {
                image = new BufferedImage(iconRectangle[0].width, iconRectangle[0].height, 2);
                Graphics g2 = ((Image)image).getGraphics();
                for (int j = 0; j < iconRectangle.length; ++j) {
                    Rectangle r = iconRectangle[j];
                    Image i = this.getImageForEffect(effectFlags);
                    g2.drawImage(i, -r.x, -r.y, null);
                }
            } else {
                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.getImageForEffect(effectFlags).getSource(), new ExtractFilter(iconRectangle[0])));
                IconManager.mediaTrackerImage(image);
            }
        }
        return image;
    }

    public Image getImage(String name) {
        return this.getImage(name, 0);
    }

    private Rectangle[] getIconRectangle(String name) {
        Rectangle[] iconRectangle;
        block11: {
            iconRectangle = null;
            String propsEntry = this.props.getProperty("icon." + name + ".rectangle");
            if (null != propsEntry) {
                StringTokenizer tok = new StringTokenizer(propsEntry, " \t,");
                try {
                    iconRectangle = new Rectangle[]{new Rectangle(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()))};
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Can't parse the icon rectangle for " + name);
                    }
                    break block11;
                }
            }
            propsEntry = this.props.getProperty("icon." + name + ".composite");
            if (null != propsEntry) {
                LinkedList<Rectangle> rectangles;
                block12: {
                    rectangles = new LinkedList<Rectangle>();
                    StringTokenizer tok = new StringTokenizer(propsEntry, " \t,");
                    try {
                        while (tok.hasMoreTokens()) {
                            Rectangle[] r = this.getIconRectangle(tok.nextToken());
                            if (null == r) continue;
                            for (int i = 0; i < r.length; ++i) {
                                if (null == r[i]) continue;
                                rectangles.add(r[i]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block12;
                        log.warn("Can't parse the icon composite for " + name);
                    }
                }
                iconRectangle = new Rectangle[rectangles.size()];
                rectangles.toArray(iconRectangle);
            } else if (log.isWarnEnabled()) {
                log.warn("Can't find icon named " + name);
            }
        }
        return iconRectangle;
    }

    protected Image getImageForEffect(int effect) {
        if ((effect &= 0xFFFFFFFC) == 0) {
            return this.iconImage;
        }
        Integer ei = new Integer(effect);
        if (!this.effectImages.containsKey(ei)) {
            ImageProducer prod = this.iconImage.getSource();
            if ((effect & 0x44) != 0) {
                prod = new FilteredImageSource(prod, new GrayFilter((effect & 4) != 0 ? 100 : 50));
            }
            if ((effect & 0x18) != 0) {
                prod = new FilteredImageSource(prod, new BrightnessFilter((effect & 8) != 0, 50));
            }
            if ((effect & 0x20) != 0) {
                prod = new FilteredImageSource(prod, new AlphaFilter(true, 50));
            }
            if ((effect & 0x80) != 0) {
                prod = new FilteredImageSource(prod, new ContrastFilter(0.9f, 0.5f));
            }
            Image effectImage = Toolkit.getDefaultToolkit().createImage(prod);
            IconManager.mediaTrackerImage(effectImage);
            this.effectImages.put(ei, effectImage);
        }
        return (Image)this.effectImages.get(ei);
    }

    public int getAutoDisableFlags() {
        return this.autoDisableFlags;
    }

    public void setAutoDisableFlags(int autoDisableFlags) {
        this.autoDisableFlags = autoDisableFlags;
    }

    public int getAutoRolloverFlags() {
        return this.autoRolloverFlags;
    }

    public void setAutoRolloverFlags(int autoRolloverFlags) {
        this.autoRolloverFlags = autoRolloverFlags;
    }

    public int getDefaultEffects() {
        return this.defaultEffects;
    }

    public void setDefaultEffects(int defaultEffects) {
        this.defaultEffects = defaultEffects;
    }

    public class IconManagerLevigoIcon
    implements LevigoIcon {
        private Rectangle[] iconRectangles = null;
        private int effect = 0;
        private Dimension targetSize = null;
        private boolean useScaling = false;

        private IconManagerLevigoIcon() {
        }

        protected IconManagerLevigoIcon(Rectangle[] iconRectangles, int effect, Dimension targetSize) {
            this.iconRectangles = iconRectangles;
            this.effect = effect;
            this.targetSize = null != targetSize ? targetSize : iconRectangles[0].getSize();
            this.useScaling = this.targetSize.width != iconRectangles[0].width || this.targetSize.height != iconRectangles[0].height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int usedEffect = this.effect;
            if ((this.effect & 1) != 0 && !c.isEnabled()) {
                usedEffect = IconManager.this.autoDisableFlags;
            }
            try {
                JButton b;
                if ((this.effect & 2) != 0 && c instanceof JButton && (b = (JButton)c).isRolloverEnabled() && b.getModel().isRollover()) {
                    usedEffect |= IconManager.this.autoRolloverFlags;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Object savedRenderingHint = null;
            try {
                if (this.useScaling && g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    savedRenderingHint = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.iconRectangles.length; ++i) {
                if (null == this.iconRectangles[i]) continue;
                g.drawImage(IconManager.this.getImageForEffect(usedEffect), x, y, x + this.targetSize.width, y + this.targetSize.height, this.iconRectangles[i].x, this.iconRectangles[i].y, this.iconRectangles[i].x + this.iconRectangles[i].width, this.iconRectangles[i].y + this.iconRectangles[i].height, c);
            }
            try {
                if (null != savedRenderingHint) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedRenderingHint);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public int getIconWidth() {
            return this.targetSize.width;
        }

        public int getIconHeight() {
            return this.targetSize.height;
        }
    }

    public class IconManagerIcon
    extends IconManagerLevigoIcon
    implements Icon {
        protected IconManagerIcon(Rectangle[] iconRectangles, int effect, Dimension targetSize) {
            super(iconRectangles, effect, targetSize);
        }
    }
}

