/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ImageTitledComponent
extends JComponent {
    String title;
    Image myImage;
    int imgWidth = -1;
    int imgHeight = -1;

    public ImageTitledComponent(JComponent c, String title, Image img) {
        this.title = title;
        this.setLayout(new BorderLayout());
        this.add((Component)c, "North");
        this.setImage(img);
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(UIManager.getColor("Label.foreground"));
    }

    public ImageTitledComponent(JComponent c, String title, Color titleColor, Image img) {
        this.title = title;
        this.setLayout(new BorderLayout());
        this.add((Component)c, "North");
        this.setForeground(titleColor);
        this.setImage(img);
        this.setFont(UIManager.getFont("Label.font"));
    }

    public Insets getInsets() {
        Graphics g = this.getGraphics();
        FontMetrics aFMetrics = g.getFontMetrics();
        g.dispose();
        return new Insets(Math.max(aFMetrics.getHeight(), this.imgHeight), 2, 2, 2);
    }

    public void paint(Graphics g) {
        Dimension mySize = this.getSize();
        g.setFont(this.getFont());
        FontMetrics aFMetrics = g.getFontMetrics();
        int myHeight = aFMetrics.getHeight();
        g.setColor(SystemColor.controlLtHighlight);
        g.drawRect(1, myHeight / 2 + 1, mySize.width - 2, mySize.height - 2 - myHeight / 2);
        g.setColor(SystemColor.controlShadow);
        g.drawRect(0, myHeight / 2, mySize.width - 2, mySize.height - 2 - myHeight / 2);
        g.setColor(this.getBackground());
        g.clearRect(10, 0, aFMetrics.stringWidth(this.title) + 10 + this.imgWidth, Math.max(aFMetrics.getHeight(), this.imgHeight));
        g.setColor(this.getForeground());
        g.drawImage(this.myImage, 12, 0, this);
        g.drawString(this.title, 16 + this.imgWidth, aFMetrics.getAscent());
        super.paint(g);
    }

    public void setImage(Image image) {
        if (this.myImage != null) {
            this.myImage.flush();
        }
        this.myImage = image;
        if (this.myImage != null) {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.myImage, 0);
            try {
                mt.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imgWidth = this.myImage.getWidth(this);
            this.imgHeight = this.myImage.getHeight(this);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }
}

