/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class LevigoSeparators {
    public static int VERTICAL = 1;
    public static int HORIZONTAL = 0;

    public static JComponent createBlueLineSeparator() {
        return new BlueLineSeparator();
    }

    public static JComponent createDoubleLineSeparator() {
        return new DoubleLineSeparator();
    }

    public static JComponent createDoubleLineSeparator(int inset) {
        DoubleLineSeparator dls = new DoubleLineSeparator();
        dls.setInset(inset);
        return dls;
    }

    public static JComponent createDoubleLineSeparator(int inset, int orientation) {
        DoubleLineSeparator dls = new DoubleLineSeparator();
        dls.setOrientation(orientation);
        dls.setInset(inset);
        return dls;
    }

    public static JComponent createSingleLineSeparator() {
        return new SingleLineSeparator();
    }

    public static JComponent createSingleLineSeparator(int inset) {
        SingleLineSeparator sls = new SingleLineSeparator();
        sls.setInset(inset);
        return sls;
    }

    public static JComponent createSingleLineSeparator(int inset, int orientation) {
        SingleLineSeparator sls = new SingleLineSeparator();
        sls.setOrientation(orientation);
        sls.setInset(inset);
        return sls;
    }

    public static class PlainSeparator
    extends AbstractLineSeparator {
        private Color color;

        public PlainSeparator(Color color) {
            this.color = color;
            this.minimumSize = new Dimension(2, 2);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            g.setColor(this.color);
            if (this.orientation == VERTICAL) {
                g.fillRect(this.inset, this.inset, d.width - this.inset, d.height - this.inset);
            } else {
                g.fillRect(this.inset, this.inset, d.width - this.inset, d.height - this.inset);
            }
        }
    }

    public static class BlueLineSeparator
    extends AbstractLineSeparator {
        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(UIManager.getColor("Label.foreground"));
            g.drawLine(1, 2, d.width, 2);
            g.setColor(g.getColor().brighter().brighter());
            g.drawLine(1, 1, d.width, 1);
            g.setColor(this.getBackground().darker());
            g.drawLine(0, 3, d.width, 3);
        }
    }

    public static class SingleLineSeparator
    extends AbstractLineSeparator {
        public SingleLineSeparator() {
            this.minimumSize = new Dimension(2, 2);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            g.setColor(this.getBackground().darker());
            if (this.orientation == VERTICAL) {
                g.drawLine(0, this.inset, 0, d.height - this.inset);
                g.setColor(this.getBackground().brighter());
                g.drawLine(1, this.inset, 1, d.height - this.inset);
            } else {
                g.drawLine(this.inset, 0, d.width - this.inset, 0);
                g.setColor(this.getBackground().brighter());
                g.drawLine(this.inset, 1, d.width - this.inset, 1);
            }
        }
    }

    public static class DoubleLineSeparator
    extends AbstractLineSeparator {
        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            g.setColor(this.getBackground().darker());
            if (this.orientation == VERTICAL) {
                g.drawLine(0, this.inset, 0, d.height - this.inset);
                g.drawLine(3, this.inset, 3, d.height - this.inset);
                g.setColor(this.getBackground().brighter());
                g.drawLine(1, this.inset, 1, d.height - this.inset);
                g.drawLine(4, this.inset, 4, d.height - this.inset);
            } else {
                g.drawLine(this.inset, 0, d.width - this.inset, 0);
                g.drawLine(this.inset, 3, d.width - this.inset, 3);
                g.setColor(this.getBackground().brighter());
                g.drawLine(this.inset, 1, d.width - this.inset, 1);
                g.drawLine(this.inset, 4, d.width - this.inset, 4);
            }
        }
    }

    public static abstract class AbstractLineSeparator
    extends JComponent {
        protected Dimension minimumSize = new Dimension(5, 5);
        protected int orientation = -1;
        protected int inset = 0;

        public void paint(Graphics g) {
            super.paint(g);
            this.updateOrientationAccordingToParent();
        }

        protected void updateOrientationAccordingToParent() {
            if (this.getParent() != null && this.getParent() instanceof JToolBar) {
                int previousOrientation = this.orientation;
                this.orientation = ((JToolBar)this.getParent()).getOrientation() == 1 ? HORIZONTAL : VERTICAL;
                if (this.orientation != previousOrientation) {
                    this.invalidate();
                }
            } else if (this.orientation == -1) {
                this.orientation = VERTICAL;
            }
        }

        public void setInset(int inset) {
            this.inset = inset;
        }

        public void setOrientation(int orientation) {
            this.orientation = orientation;
        }

        public Dimension getPreferredSize() {
            return this.minimumSize;
        }

        public Dimension getMaximumSize() {
            this.updateOrientationAccordingToParent();
            Dimension d = new Dimension(this.orientation != HORIZONTAL ? this.minimumSize.width : Integer.MAX_VALUE, this.orientation != VERTICAL ? this.minimumSize.height : Integer.MAX_VALUE);
            return d;
        }

        public Dimension getMinimumSize() {
            return this.minimumSize;
        }
    }
}

