/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.swing.SlickBevelBorder;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class NonUglyActionButton
extends JButton {
    public static final int WITHOUT_BORDER = 0;
    public static final int WITH_BORDER = 1;
    public static final int TOOLBAR_MAINOFFICE = 3;
    public static final int TOOLBAR_APPLICATION = 4;
    private static Font timesFont = new Font("Times-Roman", 0, 10);
    private static Border defaultButtonBorder = new SlickBevelBorder(SlickBevelBorder.AUTO_SELECT);
    private RolloverListener rolloverListener = new RolloverListener();

    public NonUglyActionButton() {
        this(null, null, 4);
    }

    public NonUglyActionButton(Action action) {
        this(action, 4);
    }

    public NonUglyActionButton(Action action, int style) {
        super(action);
        this.setAction(action);
        this.initialize(style);
        this.setText("");
    }

    public NonUglyActionButton(Icon icon) {
        this(null, icon, 0);
    }

    public NonUglyActionButton(Icon icon, int style) {
        this(null, icon, style);
    }

    public NonUglyActionButton(String name, Icon icon) {
        this(name, icon, 0);
    }

    public NonUglyActionButton(String name, Icon icon, int style) {
        super(name, icon);
        this.initialize(style);
    }

    public void initialize(int style) {
        this.setFont(timesFont);
        this.setFocusPainted(false);
        if (style > 0) {
            this.setBorderPainted(true);
        } else {
            this.setBorderPainted(false);
        }
        this.setMargin(new Insets(-1, -1, -1, -1));
        this.setRolloverEnabled(true);
        Border border = defaultButtonBorder;
        if (style == 4) {
            border = new SlickBevelBorder(SlickBevelBorder.AUTO_ROLLOVER | SlickBevelBorder.AUTO_SELECT);
        }
        if (style == 3) {
            border = new EtchedBorder();
        }
        super.setBorder(border);
        this.addMouseListener(this.rolloverListener);
    }

    public void setBorder(Border border) {
    }

    public void setRolloverEnabled(boolean b) {
        super.setRolloverEnabled(true);
    }

    private class RolloverListener
    extends MouseAdapter {
        private RolloverListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }
}

