/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;
import com.levigo.util.swing.TGASwingUtilWorkerThreads;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class TGASwingUtil {
    private static final Logger log = LoggerFactory.getLogger((Class)TGASwingUtil.class);
    private static ThreadGroup defaultThreadGroup = null;
    private static Hashtable threadGroups = null;
    private static boolean active = false;
    private static boolean destroyed = false;

    public static synchronized ThreadGroup getDefaultThreadGroup() {
        if (null == defaultThreadGroup && !TGASwingUtil.isDestroyed()) {
            defaultThreadGroup = Thread.currentThread().getThreadGroup();
        }
        return defaultThreadGroup;
    }

    public static synchronized void setDefaultThreadGroup(ThreadGroup tg) {
        defaultThreadGroup = tg;
    }

    public static Throwable invokeAndWait(Runnable code) {
        return TGASwingUtil.invokeAndWait(TGASwingUtil.getDefaultThreadGroup(), code);
    }

    public static Throwable invokeAndWait(ThreadGroup threadGroup, Runnable code) {
        if (TGASwingUtil.isActive()) {
            if (!TGASwingUtil.isDestroyed()) {
                TGASwingUtilWorkerThreads tw = TGASwingUtil.getWorkerThreads(threadGroup);
                return tw.invokeAndWait(code);
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(code);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return e.getTargetException();
            }
        }
        return null;
    }

    public static void invokeLater(Runnable code) {
        TGASwingUtil.invokeLater(TGASwingUtil.getDefaultThreadGroup(), code);
    }

    public static void invokeLater(ThreadGroup threadGroup, Runnable code) {
        if (TGASwingUtil.isActive()) {
            if (!TGASwingUtil.isDestroyed()) {
                TGASwingUtilWorkerThreads tw = TGASwingUtil.getWorkerThreads(threadGroup);
                tw.invokeLater(code);
            }
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    private static synchronized TGASwingUtilWorkerThreads getWorkerThreads(ThreadGroup threadGroup) {
        TGASwingUtilWorkerThreads tw = (TGASwingUtilWorkerThreads)TGASwingUtil.getThreadGroupTable().get(threadGroup);
        if (null == tw) {
            tw = new TGASwingUtilWorkerThreads(threadGroup);
            TGASwingUtil.getThreadGroupTable().put(threadGroup, tw);
        }
        return tw;
    }

    private static synchronized Hashtable getThreadGroupTable() {
        if (null == threadGroups) {
            threadGroups = new Hashtable();
        }
        return threadGroups;
    }

    public static synchronized void destroy() {
        destroyed = true;
        if (null != threadGroups) {
            Enumeration enumerator = TGASwingUtil.getThreadGroupTable().elements();
            while (enumerator.hasMoreElements()) {
                TGASwingUtilWorkerThreads wt = (TGASwingUtilWorkerThreads)enumerator.nextElement();
                if (null == wt) continue;
                wt.destroy();
            }
            threadGroups.clear();
            threadGroups = null;
            TGASwingUtil.setDefaultThreadGroup(null);
        }
    }

    public static synchronized void destroy(ThreadGroup tg) {
        TGASwingUtilWorkerThreads wt;
        if (null != threadGroups && null != (wt = (TGASwingUtilWorkerThreads)TGASwingUtil.getThreadGroupTable().get(tg))) {
            wt.destroy();
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void setActive(boolean active) {
        TGASwingUtil.active = active;
    }

    public static boolean isEventDispatchThread() {
        if (TGASwingUtil.isActive()) {
            boolean currentTGisinTGtable;
            boolean swISedt = SwingUtilities.isEventDispatchThread();
            ThreadGroup currentTG = Thread.currentThread().getThreadGroup();
            boolean currentTGisDefaultTG = currentTG == TGASwingUtil.getDefaultThreadGroup();
            boolean bl = currentTGisinTGtable = null != TGASwingUtil.getThreadGroupTable().get(Thread.currentThread().getThreadGroup());
            if (log.isDebugEnabled()) {
                log.debug("swISedt: " + swISedt + " - currentTGisDefaultTG: " + currentTGisDefaultTG + " - currentTGisinTGtable: " + currentTGisinTGtable);
            }
            return swISedt && currentTGisDefaultTG && currentTGisinTGtable;
        }
        return SwingUtilities.isEventDispatchThread();
    }

    public static boolean isEventDispatchThread(ThreadGroup tg) {
        return Thread.currentThread().getThreadGroup() == tg && TGASwingUtil.isEventDispatchThread();
    }

    public static synchronized boolean isDestroyed() {
        return destroyed;
    }

    public static synchronized void init() {
        destroyed = false;
    }
}

