/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

class TGASwingUtilWorkerThreads {
    private static final Logger log = LoggerFactory.getLogger((Class)TGASwingUtilWorkerThreads.class);
    static long instanceID = 0L;
    private ExecutionQueue asyncWorker = null;
    private ExecutionQueue syncWorker = null;

    TGASwingUtilWorkerThreads(ThreadGroup tg) {
        this.asyncWorker = new ExecutionQueue(tg, false);
        this.asyncWorker.start();
        this.syncWorker = new ExecutionQueue(tg, true);
        this.syncWorker.start();
    }

    void invokeLater(Runnable r) {
        this.asyncWorker.queueWork(r);
    }

    Throwable invokeAndWait(Runnable r) {
        return this.syncWorker.execute(r);
    }

    void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("destroy()");
        }
        this.asyncWorker.setRunning(false);
        this.syncWorker.setRunning(false);
    }

    public String toString() {
        if (null != this.asyncWorker && null != this.syncWorker) {
            return "TGASwingUtilWorkerThreads: " + this.asyncWorker.getName() + "+" + this.syncWorker.getName();
        }
        return "TGASwingUtilWorkerThreads";
    }

    class ExecutionQueue
    extends Thread {
        private Vector queue;
        private boolean sync;
        boolean running;

        ExecutionQueue(ThreadGroup tg, boolean synchronous) {
            super(tg, "TGAWorkerThread-" + instanceID++ + "-sync[" + synchronous + "]");
            this.queue = null;
            this.sync = true;
            this.running = true;
            this.queue = new Vector();
            this.sync = synchronous;
        }

        void queueWork(Runnable r) {
            log.debug("> queueWork - " + Thread.currentThread().getName() + ": entered: " + r.toString());
            this.addRunnable(r);
            if (log.isDebugEnabled()) {
                log.debug("> queueWork - " + Thread.currentThread().getName() + ": exiting: " + r.toString());
            }
        }

        Throwable execute(Runnable r) {
            if (log.isDebugEnabled()) {
                log.debug("> execute - " + Thread.currentThread().getName() + ": entered: " + r.toString());
            }
            WorkItemWrapper wrapper = this.addRunnable(r);
            if (log.isDebugEnabled()) {
                log.debug("> execute - " + Thread.currentThread().getName() + ": added Runnable: " + r.toString());
            }
            wrapper.waitTillDone();
            if (log.isDebugEnabled()) {
                log.debug("> execute - " + Thread.currentThread().getName() + ": exiting: " + r.toString());
            }
            return wrapper.getThrowable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug("< run: " + Thread.currentThread().getName() + ": entered run method.");
            }
            while (true) {
                block28: {
                    if (!this.isRunning()) {
                        if (!log.isDebugEnabled()) return;
                        log.debug("< run: " + Thread.currentThread().getName() + ": leaving run method.");
                        return;
                    }
                    WorkItemWrapper workItem = null;
                    if (log.isDebugEnabled()) {
                        log.debug("< run: " + Thread.currentThread().getName() + ": looping in run, entering synchronized block.");
                    }
                    ExecutionQueue executionQueue = this;
                    // MONITORENTER : executionQueue
                    while (this.queue.size() == 0 && this.isRunning()) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug("< run: " + Thread.currentThread().getName() + ": about to wait.");
                            }
                            this.wait();
                            if (!log.isDebugEnabled()) continue;
                            log.debug("< run: " + Thread.currentThread().getName() + ": finished waiting.");
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.queue.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("< run: " + Thread.currentThread().getName() + ": queue size: " + this.queue.size());
                        }
                        workItem = (WorkItemWrapper)this.queue.remove(0);
                        if (log.isDebugEnabled()) {
                            log.debug("< run: " + Thread.currentThread().getName() + ": removed work item: " + workItem.toString());
                        }
                    }
                    // MONITOREXIT : executionQueue
                    if (log.isDebugEnabled()) {
                        log.debug("< run: " + Thread.currentThread().getName() + ": exiting synchronized block.");
                    }
                    if (null != workItem) {
                        try {
                            if (this.sync) {
                                if (log.isDebugEnabled()) {
                                    log.debug("< run: " + Thread.currentThread().getName() + ": about to call SwingUtilities.invokeAndWait() for: " + workItem.toString());
                                }
                                SwingUtilities.invokeAndWait(workItem.getWork());
                                if (log.isDebugEnabled()) {
                                    log.debug("< run: " + Thread.currentThread().getName() + ": finished calling SwingUtilities.invokeAndWait() for: " + workItem.toString());
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("< run: " + Thread.currentThread().getName() + ": entered synchronized block, about to call notify for: " + workItem.toString());
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("< run: " + Thread.currentThread().getName() + ": about to leave synchronized block, finished calling notify for: " + workItem.toString());
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("< run: " + Thread.currentThread().getName() + ": left synchronized block: " + workItem.toString());
                                }
                                break block28;
                            }
                            SwingUtilities.invokeLater(workItem.getWork());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            workItem.setThrowable(e.getTargetException());
                            e.printStackTrace();
                        }
                        finally {
                            workItem.done();
                        }
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("< run: " + Thread.currentThread().getName() + ": finished loop cycle.");
            }
        }

        synchronized WorkItemWrapper addRunnable(Runnable r) {
            WorkItemWrapper wrapper = new WorkItemWrapper(r);
            this.queue.add(wrapper);
            this.notify();
            return wrapper;
        }

        synchronized boolean isRunning() {
            return this.running;
        }

        synchronized void setRunning(boolean running) {
            this.running = running;
            this.notify();
        }
    }

    private static class WorkItemWrapper {
        private final Runnable item;
        private Throwable throwable;
        private boolean done = false;

        WorkItemWrapper(Runnable item) {
            this.item = item;
        }

        private synchronized void waitTillDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private synchronized void done() {
            this.done = true;
            this.notify();
        }

        private Runnable getWork() {
            return this.item;
        }

        public String toString() {
            return this.item.toString();
        }

        private Throwable getThrowable() {
            return this.throwable;
        }

        private void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

