/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.swing.PanelTitleBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TitledPanel
extends JPanel {
    private static final EmptyBorder BORDER = new EmptyBorder(2, 2, 2, 2);
    private JComponent contentPanel;
    private PanelTitleBar panelTitleBar;
    private final boolean useDynamicTitle;
    private PropertyChangeListener listener;

    public TitledPanel(JComponent contentPanel) {
        this(contentPanel, null);
    }

    public TitledPanel(String title) {
        this(null, title);
    }

    public TitledPanel(JComponent contentPanel, String title) {
        this.contentPanel = contentPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(UIManager.getBorder("TitledPanel.border"));
        this.useDynamicTitle = null == title;
        this.panelTitleBar = new PanelTitleBar(title != null ? title : "");
        this.add((Component)this.panelTitleBar, "North");
        if (null != contentPanel) {
            this.setContentPanel(contentPanel);
        }
    }

    public void setContentPanel(JComponent contentPanel) {
        if (null != this.contentPanel) {
            if (null != this.listener) {
                this.contentPanel.removePropertyChangeListener(this.listener);
            }
            this.remove(this.contentPanel);
        }
        contentPanel.setBorder(BORDER);
        this.add((Component)contentPanel, "Center");
        this.contentPanel = contentPanel;
        if (this.useDynamicTitle) {
            String title = contentPanel.getName();
            this.setTitle(title);
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("name")) {
                        TitledPanel.this.setTitle(evt.getNewValue() != null ? evt.getNewValue().toString() : "");
                    } else if (evt.getPropertyName().equals("icon")) {
                        TitledPanel.this.updateIcon();
                    }
                }
            };
            contentPanel.addPropertyChangeListener(this.listener);
        }
        this.updateIcon();
    }

    protected void updateIcon() {
        if (null == this.contentPanel) {
            this.setIcon(null);
        }
        Class[] args = new Class[]{};
        try {
            Method m = this.contentPanel.getClass().getMethod("getIcon", args);
            Object result = m.invoke((Object)this.contentPanel, null);
            if (result instanceof Icon) {
                this.setIcon((Icon)result);
            } else {
                this.setIcon(null);
            }
        }
        catch (Exception e) {
            this.setIcon(null);
        }
    }

    public void setTitle(String title) {
        this.panelTitleBar.setTitle(title != null ? title : "");
    }

    public Icon getIcon() {
        return this.panelTitleBar.getIcon();
    }

    public int getIconTextGap() {
        return this.panelTitleBar.getIconTextGap();
    }

    public void setIcon(Icon icon) {
        this.panelTitleBar.setIcon(icon);
    }

    public void setIconTextGap(int iconTextGap) {
        this.panelTitleBar.setIconTextGap(iconTextGap);
    }
}

