/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.progress.BlueLineProgressEventListener;
import com.levigo.util.progress.Progress;
import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import com.levigo.util.swing.PendingOperations;
import com.levigo.util.swing.SwingWorker;
import com.levigo.util.swing.action.AbstractCommand;
import java.lang.reflect.Constructor;
import java.util.Collection;

public abstract class AbstractAsyncCommand
extends AbstractCommand {
    public static final String CONTEXT_KEY = "commands.async";
    private static int executionCounter = 0;
    private static String listenerClass = null;
    static /* synthetic */ Class class$com$levigo$util$progress$ProgressSource;

    public static void setListenerClass(String className) {
        listenerClass = className;
    }

    public final void doExecute(Collection args) {
        this.doPrepare(args);
        new CommandSwingWorker(args).start();
    }

    protected void doPrepare(Collection args) {
    }

    public final void doExecuteSynchronously(Collection args) {
        CommandSwingWorker worker = new CommandSwingWorker(args);
        worker.start();
        try {
            worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void executeSynchronously(Collection args) {
        if (!this.checkQuickly(args)) {
            return;
        }
        if (!this.checkDeeply(args)) {
            return;
        }
        this.finished(args, this.construct(args, new ProgressSource(){

            public String getProgressSourceName() {
                return "foo";
            }

            public Progress getProgress() {
                return new Progress();
            }

            public boolean canCancel() {
                return false;
            }

            public void cancel() {
            }

            public void abort() {
            }
        }));
    }

    public abstract boolean canCancel();

    public abstract Object construct(Collection var1, ProgressSource var2);

    public abstract void finished(Collection var1, Object var2);

    public abstract String getProgressSourceName();

    public abstract int getStepCount(Collection var1);

    public class CommandSwingWorker
    extends SwingWorker
    implements ProgressSource {
        private Collection args;
        private Progress progress;
        private boolean inProgress;

        public CommandSwingWorker(Collection args) {
            super("AsyncCommand: " + AbstractAsyncCommand.this.toString() + "(" + executionCounter++ + ")");
            this.inProgress = true;
            this.args = args;
        }

        public Object construct() {
            this.progress = new Progress(0, AbstractAsyncCommand.this.getStepCount(this.args), 0, this.getProgressSourceName(), true, this);
            if (AbstractAsyncCommand.this.getStepCount(this.args) > 1) {
                if (listenerClass == null) {
                    new BlueLineProgressEventListener(this);
                } else {
                    try {
                        Class<?> lc = Class.forName(listenerClass);
                        Constructor<?> c = lc.getConstructor(class$com$levigo$util$progress$ProgressSource == null ? (class$com$levigo$util$progress$ProgressSource = AbstractAsyncCommand.class$("com.levigo.util.progress.ProgressSource")) : class$com$levigo$util$progress$ProgressSource);
                        c.newInstance(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        new BlueLineProgressEventListener(this);
                    }
                }
            }
            ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this, "statusChanged", "inProgress"));
            PendingOperations.getInstance(AbstractAsyncCommand.CONTEXT_KEY).started(this);
            Object returnValue = AbstractAsyncCommand.this.construct(this.args, this);
            if (this.inProgress) {
                ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this, "statusChanged", "finished"));
            }
            return returnValue;
        }

        public void finished() {
            AbstractAsyncCommand.this.finished(this.args, this.getValue());
            PendingOperations.getInstance(AbstractAsyncCommand.CONTEXT_KEY).finished(this);
        }

        public boolean canCancel() {
            return AbstractAsyncCommand.this.canCancel();
        }

        public void cancel() {
            this.inProgress = false;
            ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this, "statusChanged", "cancelled"));
            this.progress.setCancelled(true);
        }

        public Progress getProgress() {
            return this.progress;
        }

        public String getProgressSourceName() {
            return AbstractAsyncCommand.this.getProgressSourceName();
        }

        public void abort() {
            this.inProgress = false;
            ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this, "statusChanged", "aborted"));
        }
    }
}

