/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.Context;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCommand
implements Command {
    protected static final int NONE = -1;
    protected static final int ONE = 1;
    protected static final int ONE_OR_MORE = 2;
    protected static final int ONE_EXCLUSIVE = 3;
    protected static final int ONE_OR_MORE_EXCLUSIVE = 4;
    private String commandKey = null;
    private String[] parameters = null;

    public final void execute(Collection args) {
        if (!this.checkQuickly(args)) {
            return;
        }
        if (!this.checkDeeply(args)) {
            return;
        }
        this.doExecute(args);
    }

    public boolean checkQuickly(Collection args) {
        return this.checkDeeply(args);
    }

    public abstract boolean checkDeeply(Collection var1);

    protected abstract void doExecute(Collection var1);

    protected final int getClassCount(Class checkClass, Collection args) {
        if (args == null || args.size() < 1) {
            return 0;
        }
        Iterator itr = args.iterator();
        int returnValue = 0;
        while (itr.hasNext()) {
            if (!itr.next().getClass().isInstance(checkClass)) continue;
            ++returnValue;
        }
        return returnValue;
    }

    protected final boolean isArgumentValid(int countSpecifier, Class checkClass, Collection args) {
        boolean resultValue = true;
        block0 : switch (countSpecifier) {
            case -1: {
                if (args == null || args.isEmpty()) {
                    resultValue = true;
                    break;
                }
                Iterator itr = args.iterator();
                while (itr.hasNext()) {
                    Class<?> readClass;
                    Object testObject = itr.next();
                    if (testObject == null || !checkClass.isAssignableFrom(readClass = testObject.getClass())) continue;
                    resultValue = false;
                    break block0;
                }
                break;
            }
            case 1: {
                if (args == null || args.isEmpty()) {
                    resultValue = false;
                    break;
                }
                Iterator itr = args.iterator();
                resultValue = false;
                Object foundInstance = null;
                while (itr.hasNext()) {
                    Object testObject = itr.next();
                    if (testObject == null) continue;
                    Class<?> readClass = testObject.getClass();
                    if (foundInstance == testObject || !checkClass.isAssignableFrom(readClass)) continue;
                    foundInstance = testObject;
                    if (resultValue) {
                        resultValue = false;
                        break block0;
                    }
                    resultValue = true;
                }
                break;
            }
            case 2: {
                Class<?> readClass;
                Object testObject;
                if (args == null || args.isEmpty()) {
                    resultValue = false;
                    break;
                }
                Iterator itr = args.iterator();
                while (itr.hasNext() && ((testObject = itr.next()) == null || !(resultValue = checkClass.isAssignableFrom(readClass = testObject.getClass())))) {
                }
                break;
            }
            case 3: {
                if (args == null || args.size() != 1) {
                    resultValue = false;
                    break;
                }
                Iterator itr = args.iterator();
                Object testObject = itr.next();
                if (testObject == null) {
                    resultValue = false;
                }
                resultValue = checkClass.isAssignableFrom(testObject.getClass());
                break;
            }
            case 4: {
                Object testObject;
                if (args == null || args.isEmpty()) {
                    resultValue = false;
                    break;
                }
                Iterator itr = args.iterator();
                while (itr.hasNext() && ((testObject = itr.next()) == null || (resultValue = checkClass.isAssignableFrom(testObject.getClass())))) {
                }
                break;
            }
            default: {
                resultValue = false;
            }
        }
        return resultValue;
    }

    protected Component getAssociatedComponent(Collection args) {
        if (args == null) {
            return null;
        }
        if (args instanceof Context) {
            return ((Context)args).getOwner();
        }
        return (Component)AbstractCommand.getClassFromArguments(args, Component.class);
    }

    public static Object getClassFromArguments(Collection args, Class checkClass) {
        Object testObject = null;
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            testObject = iterator.next();
            if (testObject == null || !checkClass.isAssignableFrom(testObject.getClass())) continue;
            return testObject;
        }
        return null;
    }

    public static Collection getClassesFromArguments(Collection args, Class checkClass) {
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        Object testObject = null;
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            testObject = iterator.next();
            if (testObject == null || !checkClass.isAssignableFrom(testObject.getClass())) continue;
            resultCollection.add(testObject);
        }
        return resultCollection;
    }

    public String getKey() {
        return this.commandKey;
    }

    void setKey(String key) {
        this.commandKey = key;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean isChecked(Collection args) {
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public String[] getCommandParameters() {
        return this.parameters;
    }

    public void setCommandParameters(String[] parameters) {
        this.parameters = parameters;
    }

    protected int getCommandParameterAsInt(int paramIndex, int defaultValue) {
        if (this.parameters != null && this.parameters.length > paramIndex && paramIndex >= 0) {
            try {
                return Integer.parseInt(this.parameters[paramIndex]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected boolean getCommandParameterAsBoolean(int paramIndex, boolean defaultValue) {
        if (this.parameters != null && this.parameters.length > paramIndex && paramIndex >= 0) {
            return Boolean.valueOf(this.parameters[paramIndex]);
        }
        return defaultValue;
    }

    protected String getCommandParameter(int paramIndex, String defaultValue) {
        if (this.parameters != null && this.parameters.length > paramIndex && paramIndex >= 0) {
            return this.parameters[paramIndex];
        }
        return defaultValue;
    }
}

