/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.configuration.PropertiesConfigurationImpl;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.CommandAction;
import com.levigo.util.swing.action.CommandFactory;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.DefaultActionFactory;
import com.levigo.util.swing.action.DefaultCommandFactory;
import com.levigo.util.swing.action.NamedActionFactory;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class BasicActionFactory
implements NamedActionFactory {
    protected static Field[] fields = KeyEvent.class.getFields();
    public static final String INPUT_MAP = "InputMap";
    protected static final String VISIBLE = "visible";
    protected static final String COMMANDS = "commands";
    protected static final List EMPTY_LIST = Collections.unmodifiableList(new LinkedList());
    protected PropertiesConfigurationImpl actionLookupProperties = new PropertiesConfigurationImpl();
    protected String factoryName;

    protected BasicActionFactory(String propertiesFileName) throws Exception {
        this.factoryName = propertiesFileName;
        this.loadProperties(propertiesFileName);
    }

    protected BasicActionFactory(InputStream propertyInputStream, String factoryName) throws Exception {
        this.setFactoryName(factoryName);
        this.loadProperties(propertyInputStream);
    }

    protected BasicActionFactory() {
    }

    protected IconManager getIconManager(String key) {
        if (key == null || key.trim().equals("")) {
            return null;
        }
        int index = key.indexOf(46);
        String iconDefinition = index < 0 ? this.actionLookupProperties.getProperty("icons.defaulticons") : this.actionLookupProperties.getProperty("icons." + key.substring(0, index));
        if (iconDefinition == null) {
            return null;
        }
        return IconManager.getInstance(null, iconDefinition);
    }

    public CommandAction getAction(Context context, String key, String commands, String shortDescription, String longDescription, Icon smallIcon, String actionCommandKey, KeyStroke acceleratorKey, int mnemonicKey, HashMap otherParameters) {
        return this.getAction(context, key, null, commands, shortDescription, longDescription, smallIcon, actionCommandKey, acceleratorKey, mnemonicKey, otherParameters);
    }

    public CommandAction getAction(Context context, String key, String name, String commands, String shortDescription, String longDescription, Icon smallIcon, String actionCommandKey, KeyStroke acceleratorKey, int mnemonicKey, HashMap otherParameters) {
        if (commands == null) {
            DefaultActionFactory.fireCreationFailure(this, "No commands defined.", key, null);
            return null;
        }
        ArrayList<Command> commandsCollection = new ArrayList<Command>();
        StringTokenizer commandsToken = new StringTokenizer(commands, ",", false);
        String commandKey = null;
        while (commandsToken.hasMoreTokens()) {
            Command aCommand;
            commandKey = commandsToken.nextToken();
            if (commandKey == null || commandKey.length() <= 0 || (aCommand = this.getCommandFactory(commandKey).getCommand(commandKey)) == null) continue;
            if (!aCommand.isAvailable()) {
                DefaultActionFactory.fireCreationWarning(this, "Command " + commandKey + " is not available.", key);
                continue;
            }
            commandsCollection.add(aCommand);
        }
        if (commandsCollection.isEmpty()) {
            DefaultActionFactory.fireCreationFailure(this, "No commands created.", key, null);
            return null;
        }
        return new CommandAction(context, commandsCollection, key, name, shortDescription, longDescription, smallIcon, actionCommandKey, acceleratorKey, mnemonicKey, otherParameters);
    }

    protected Collection getParameters(String key) {
        Set test = this.actionLookupProperties.keySet();
        ArrayList<String> parametersColl = null;
        Iterator iter = test.iterator();
        int dotPos = key.length();
        while (iter.hasNext()) {
            String temp = (String)iter.next();
            if (!temp.startsWith(key) || temp.charAt(dotPos) != '.') continue;
            if (null == parametersColl) {
                parametersColl = new ArrayList<String>();
            }
            parametersColl.add(temp);
        }
        return parametersColl != null ? parametersColl : EMPTY_LIST;
    }

    protected HashMap getMoreParameters(String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Collection parametersColl = this.getParameters(key);
        Iterator iterator = parametersColl.iterator();
        while (iterator.hasNext()) {
            String temp = (String)iterator.next();
            if (temp.endsWith(".commands") || temp.endsWith(".visible") || temp.endsWith(".ShortDescription") || temp.endsWith(".LongDescription") || temp.endsWith(".AcceleratorKey") || temp.endsWith(".ActionCommandKey") || temp.endsWith(".MnemonicKey") || temp.endsWith(".Name") || temp.endsWith(".InputMap") || temp.endsWith(".SmallIcon")) continue;
            parameters.put(temp.substring(temp.indexOf(".") + 1), this.actionLookupProperties.getProperty(temp));
        }
        return parameters;
    }

    protected void loadProperties(String propertyFileName) throws IOException {
        this.actionLookupProperties.load(propertyFileName, this.getClass());
    }

    protected void loadProperties(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No properties stream available.");
        }
        this.actionLookupProperties.load(is);
        is.close();
    }

    protected final KeyStroke getKeyStroke(String keyString) {
        if (keyString == null || keyString.length() == 0) {
            return null;
        }
        int key = -1;
        int modifier = 0;
        StringTokenizer keystrokeParts = new StringTokenizer(keyString, "+", false);
        while (keystrokeParts.hasMoreTokens()) {
            String token = keystrokeParts.nextToken().trim();
            if (token == null || token.length() <= 0) continue;
            if (key < 0 && token.startsWith("VK_")) {
                key = BasicActionFactory.getKeyEventIdentifier(this, token);
                continue;
            }
            if (!token.endsWith("_MASK")) continue;
            modifier |= BasicActionFactory.getKeyEventIdentifier(this, token);
        }
        return key <= 0 ? null : KeyStroke.getKeyStroke(key, Math.max(0, modifier));
    }

    protected static int getKeyEventIdentifier(NamedActionFactory caller, String keyAsString) {
        int wantModifier = 25;
        int keyEventID = -1;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().equals(Integer.TYPE) || (fields[i].getModifiers() & wantModifier) != wantModifier || !fields[i].getName().startsWith("VK_") && !fields[i].getName().endsWith("_MASK") || !fields[i].getName().equals(keyAsString)) continue;
            try {
                keyEventID = fields[i].getInt(fields[i]);
                continue;
            }
            catch (Exception e) {
                DefaultActionFactory.fireCreationWarning(caller, "Problems occurred by key event identifier recognition (" + e.getMessage() + ").", keyAsString);
            }
        }
        return keyEventID;
    }

    public CommandAction getAction(Context context, String key) {
        CommandAction action;
        String propKey;
        int indexComma = key.indexOf(46);
        if (indexComma >= 0) {
            key = key.substring(indexComma + 1);
        }
        if (this.actionLookupProperties.getProperty((propKey = key + ".") + VISIBLE, "true").equalsIgnoreCase("false")) {
            return null;
        }
        String commands = this.actionLookupProperties.getProperty(propKey + COMMANDS);
        if (commands == null) {
            DefaultActionFactory.fireCreationFailure(this, "No commands defined.", key, null);
            return null;
        }
        String name = this.actionLookupProperties.getProperty(propKey + "Name");
        String short_descr = this.actionLookupProperties.getProperty(propKey + "ShortDescription");
        String long_descr = this.actionLookupProperties.getProperty(propKey + "LongDescription");
        String small_icon = this.actionLookupProperties.getProperty(propKey + "SmallIcon");
        String action_command_key = this.actionLookupProperties.getProperty(propKey + "ActionCommandKey");
        if (action_command_key == null || action_command_key.equals("")) {
            action_command_key = propKey;
        }
        String accelerator_key = this.actionLookupProperties.getProperty(propKey + "AcceleratorKey");
        KeyStroke acceleratorKeystroke = this.getKeyStroke(accelerator_key);
        String mnemonic_key = this.actionLookupProperties.getProperty(propKey + "MnemonicKey");
        int mnemonic = 0;
        if (mnemonic_key != null && (mnemonic_key = mnemonic_key.trim().toUpperCase()).length() > 0) {
            int c = mnemonic_key.charAt(0);
            if (!(c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 43 || c == 45)) {
                DefaultActionFactory.fireCreationWarning(this, "Illegal mnemonic key >" + (char)c + "<, will be ignored.", key);
            } else {
                if (c == 43) {
                    DefaultActionFactory.fireCreationInformation(this, "Recognized mnemonic key >" + (char)c + "< is ambiguous. It is mapped to NumPad Plus.", key);
                    c = 107;
                } else if (c == 45) {
                    DefaultActionFactory.fireCreationInformation(this, "Recognized mnemonic key >" + (char)c + "< is ambiguous. It is mapped to NumPad Minus.", key);
                    c = 109;
                }
                mnemonic = c;
            }
        }
        Icon icon = null;
        if (null != small_icon && this.getIconManager(small_icon) != null) {
            icon = this.getIconManager(small_icon).getIcon(small_icon.substring(small_icon.indexOf(46) + 1), 1);
        }
        if ((action = this.getAction(context, key, name, commands, short_descr, long_descr, icon, action_command_key, acceleratorKeystroke, mnemonic, this.getMoreParameters(key))) == null) {
            return null;
        }
        String inputmapKeys = this.actionLookupProperties.getProperty(propKey + INPUT_MAP);
        if (inputmapKeys != null && inputmapKeys.length() > 0) {
            InputMap iMap = context.getOwner().getInputMap(2);
            ActionMap aMap = context.getOwner().getActionMap();
            aMap.put(action_command_key, action);
            StringTokenizer keystrokes = new StringTokenizer(inputmapKeys, ",", false);
            KeyStroke currentKeystroke = null;
            while (keystrokes.hasMoreTokens()) {
                currentKeystroke = this.getKeyStroke(keystrokes.nextToken().trim());
                if (currentKeystroke == null) continue;
                iMap.put(currentKeystroke, action_command_key);
            }
        }
        return action;
    }

    protected CommandFactory getCommandFactory(String key) {
        String resourceName = null;
        int index = key.indexOf(46);
        resourceName = index < 0 ? this.actionLookupProperties.getProperty("resource.commands.default") : key.substring(0, index);
        String parameter = this.actionLookupProperties.getProperty("resource." + resourceName);
        return DefaultCommandFactory.getInstance(parameter);
    }

    public void putLookupProperty(String key, String value) {
        this.actionLookupProperties.setProperty(key, value);
    }

    public String getLookupProperty(String key) {
        return this.actionLookupProperties.getProperty(key);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }
}

