/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.AbstractCommand;
import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.NamedCommandFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;

public class BasicCommandFactory
implements NamedCommandFactory {
    protected HashMap commandCache = new HashMap();
    protected Properties commandLookupProperties = new Properties();
    protected String factoryName;

    protected BasicCommandFactory(String propertiesFileName) throws Exception {
        this();
        this.factoryName = propertiesFileName;
        this.loadProperties(propertiesFileName);
    }

    protected BasicCommandFactory() {
    }

    protected BasicCommandFactory(InputStream propertyInputStream, String factoryName) throws Exception {
        this.setFactoryName(factoryName);
        this.loadProperties(propertyInputStream);
    }

    protected Command getCommandFromCache(String key) {
        return (Command)this.commandCache.get(key);
    }

    protected Command putCommandIntoCache(String key, Command command) {
        return this.commandCache.put(key, command);
    }

    public Command getCommand(String key) {
        Command askedCommand = this.getCommandFromCache(key);
        if (askedCommand == null && (askedCommand = this.createCommand(key)) != null) {
            this.putCommandIntoCache(key, askedCommand);
        }
        return askedCommand;
    }

    protected Command createCommand(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Command key could not be NULL.");
        }
        if ((key = key.trim()).lastIndexOf(".") >= 0) {
            key = key.substring(key.lastIndexOf(".") + 1).trim();
        }
        AbstractCommand aCommand = null;
        String className = this.getCommandClassname(key);
        try {
            Class<?> commandClass = Class.forName(className);
            if (commandClass != null && AbstractCommand.class.isAssignableFrom(commandClass)) {
                aCommand = (AbstractCommand)commandClass.newInstance();
                aCommand.setKey(key);
                Collection parameters = this.getParameters(key);
                aCommand.setCommandParameters(parameters.toArray(new String[parameters.size()]));
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        return aCommand;
    }

    protected Collection getParameters(String commandKey) {
        ArrayList<String> parametersColl = null;
        if (commandKey != null) {
            parametersColl = new ArrayList<String>();
            String parameter = null;
            int mistakenHits = 0;
            int i = 0;
            while (mistakenHits < 3) {
                parameter = this.getLookupProperty(commandKey + ".param." + i);
                if (parameter != null) {
                    mistakenHits = 0;
                    parametersColl.add(parameter.trim());
                } else {
                    parametersColl.add("");
                    ++mistakenHits;
                }
                ++i;
            }
        }
        return parametersColl != null ? parametersColl : Collections.EMPTY_LIST;
    }

    protected String getCommandClassname(String key) {
        if (key == null) {
            return "";
        }
        String className = this.getLookupProperty(key);
        return className != null ? className.trim() : "";
    }

    protected void loadProperties(String propertiesFileName) throws IOException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(propertiesFileName);
        if (resourceAsStream == null) {
            throw new IOException("No properties stream available for " + propertiesFileName);
        }
        this.loadProperties(resourceAsStream);
    }

    protected void loadProperties(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No properties stream available.");
        }
        this.commandLookupProperties.load(is);
        is.close();
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public void putLookupProperty(String key, String value) {
        this.commandLookupProperties.setProperty(key, value);
    }

    public String getLookupProperty(String key) {
        return this.commandLookupProperties.getProperty(key);
    }
}

