/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.configuration.PropertiesConfigurationImpl;
import com.levigo.util.swing.JButtonGroup;
import com.levigo.util.swing.LevigoSeparators;
import com.levigo.util.swing.action.ActionFactory;
import com.levigo.util.swing.action.ActionJCheckboxMenuItem;
import com.levigo.util.swing.action.ActionJRadioMenuItem;
import com.levigo.util.swing.action.CommandAction;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.DefaultActionFactory;
import com.levigo.util.swing.action.DefaultMenuComponentFactory;
import com.levigo.util.swing.action.DummyCommand;
import com.levigo.util.swing.action.IconJMenuItem;
import com.levigo.util.swing.action.MenuComponentFactory;
import com.levigo.util.swing.action.NamedMenuComponentFactory;
import com.levigo.util.swing.action.NonUglyActionJToggleButton;
import com.levigo.util.swing.action.PopupJToggleButton;
import com.levigo.util.swing.action.VisibilityEnabledJCheckboxMenuItem;
import com.levigo.util.swing.action.VisibilityEnabledJMenuItem;
import com.levigo.util.swing.action.VisibilityEnabledJRadioMenuItem;
import com.levigo.util.swing.toolbar.EllipseJToolBar;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class BasicMenuComponentFactory
implements NamedMenuComponentFactory {
    protected static final String CHECKBOX_MENU = "checkbox";
    protected static final String VISIBILITY_CHECKBOX_MENU = "visibilityEnabledCheckbox";
    protected static final String VISIBILITY_RADIOBUTTON_MENU = "visibilityEnabledRadiobutton";
    protected static final String RADIOBUTTON_MENU = "radiobutton";
    protected static final String ICON_MENU = "iconmenu";
    protected static final String VISIBILITY_MENU = "visibilityEnabled";
    protected static final String SELECTED_MENU = "selected";
    protected static final String TEXT = ".name";
    protected static final String SUBMENU_ACTION = ".action";
    protected static final String MNEMONICKEY = ".MnemonicKey";
    protected static final String SEPARATOR = "|";
    protected static final String SUBMENUVARIABLE = "{>";
    protected static final String VARIABLE = "{";
    protected static final String EXTERNAL_ACTION = "$";
    protected static final String STARTSUB = "{StartSubMenu=";
    protected static final String ENDSUB = "{EndSubMenu=";
    protected PropertiesConfigurationImpl compositionLookupProperties = new PropertiesConfigurationImpl();
    protected String factoryName;

    protected BasicMenuComponentFactory(String propertiesFileName) throws Exception {
        this.factoryName = propertiesFileName;
        this.loadProperties(propertiesFileName);
    }

    protected BasicMenuComponentFactory(InputStream propertyInputStream, String factoryName) throws Exception {
        this.setFactoryName(factoryName);
        this.loadProperties(propertyInputStream);
    }

    public JToolBar getToolbar(String key, Context context) {
        return this.doCreateToolbar(this.getStructureOfActionNames(key, ".toolbar"), context, null);
    }

    public JToolBar getToolbar(String key, Context context, Action[] additionalActions) {
        return this.doCreateToolbar(this.getStructureOfActionNames(key, ".toolbar"), context, additionalActions);
    }

    public JMenu getMenu(String key, Context context) {
        return this.getMenu(key, context, null);
    }

    public JMenu getMenu(String key, Context context, Action[] additionalActions) {
        return this.doCreateMenu(key, this.getStructureOfActionNames(key, ".menu"), context, additionalActions);
    }

    public JPopupMenu getContextMenu(String key, Context context) {
        return this.getContextMenu(key, context, null);
    }

    public JPopupMenu getContextMenu(String key, Context context, Action[] additionalActions) {
        return this.doCreateContextMenu(key, this.getStructureOfActionNames(key, ".contextmenu"), context, additionalActions);
    }

    protected ActionFactory getActionFactory(String key) {
        String sourceName = null;
        int index = key.indexOf(46);
        sourceName = index < 0 ? this.compositionLookupProperties.getProperty("resource.actions.default") : key.substring(0, index);
        String parameter = this.compositionLookupProperties.getProperty("resource." + sourceName);
        return DefaultActionFactory.getInstance(parameter);
    }

    public Collection getActions(String key) {
        return this.getStructureOfActionNames(key, ".actions");
    }

    public Collection getActionsForType(String key, String type) {
        return this.getStructureOfActionNames(key, type);
    }

    public Collection getCommandActions(String key, Context context) {
        Collection actionNames = this.getActions(key);
        ArrayList<CommandAction> allActions = new ArrayList<CommandAction>();
        if (actionNames != null) {
            Iterator it = actionNames.iterator();
            while (it.hasNext()) {
                CommandAction anAction;
                Object nextAction = it.next();
                if (!(nextAction instanceof String) || (anAction = this.getActionFactory((String)nextAction).getAction(context, (String)nextAction)) == null) continue;
                allActions.add(anAction);
            }
        }
        return allActions;
    }

    protected JToolBar doCreateToolbar(Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        EllipseJToolBar toolBar = new EllipseJToolBar();
        Action action = null;
        String metaInfo = null;
        Object nextIter = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                action = nextIter;
            } else {
                metaInfo = nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    ActionFactory af;
                    String popupActionName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JPopupMenu popupMenu = null;
                    ArrayList<String> subMenuCollection = new ArrayList<String>();
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + popupActionName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    popupMenu = this.doCreateContextMenu(popupActionName, subMenuCollection, context, additionalActions);
                    if (popupMenu != null) {
                        popupMenu.setName(popupActionName);
                    }
                    if ((af = this.getActionFactory(metaInfo)) != null) {
                        action = af.getAction(context, popupActionName);
                    }
                    if (action != null) {
                        toolBar.add(new PopupJToggleButton(action, popupMenu));
                    }
                    action = null;
                } else if (!metaInfo.startsWith(ENDSUB)) {
                    if (metaInfo.startsWith(SEPARATOR)) {
                        toolBar.add(LevigoSeparators.createSingleLineSeparator(2));
                    } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                        if (additionalActions != null) {
                            String nextActionName = metaInfo.substring(1);
                            for (int i = 0; i < additionalActions.length; ++i) {
                                if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                                action = additionalActions[i];
                                this.putValuesInAdditionalActions(context, action, metaInfo);
                                break;
                            }
                        }
                    } else {
                        ActionFactory af = this.getActionFactory(metaInfo);
                        if (af != null) {
                            action = af.getAction(context, metaInfo);
                        }
                    }
                }
            }
            if (null == action) continue;
            toolBar.add(this.doCreateComponentForAction(action));
        }
        return toolBar;
    }

    protected void putValuesInAdditionalActions(Context context, Action action, String metaInfo) {
        CommandAction dummyAction;
        ActionFactory af = this.getActionFactory(metaInfo);
        CommandAction commandAction = dummyAction = af != null ? af.getAction(context, metaInfo) : null;
        if (dummyAction != null) {
            if (dummyAction.getValue("ShortDescription") != null && !dummyAction.getValue("ShortDescription").equals("")) {
                action.putValue("ShortDescription", dummyAction.getValue("ShortDescription"));
            }
            if (dummyAction.getValue("LongDescription") != null && !dummyAction.getValue("LongDescription").equals("")) {
                action.putValue("LongDescription", dummyAction.getValue("LongDescription"));
            }
            if (dummyAction.getValue("SmallIcon") != null) {
                action.putValue("SmallIcon", dummyAction.getValue("SmallIcon"));
            }
            if (dummyAction.getValue("AcceleratorKey") != null) {
                action.putValue("AcceleratorKey", dummyAction.getValue("AcceleratorKey"));
            }
            if (dummyAction.getValue("MnemonicKey") != null) {
                action.putValue("MnemonicKey", dummyAction.getValue("MnemonicKey"));
            }
        }
    }

    protected JComponent doCreateComponentForAction(Action action) {
        if (null != action.getValue("SmallIcon")) {
            return new NonUglyActionJToggleButton(action);
        }
        return new JButton(action);
    }

    protected JMenu doCreateMenu(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        String menuName = null;
        String mnemonicKey = null;
        if (key != null && (menuName = this.compositionLookupProperties.getProperty(key + ".actions" + TEXT, null)) == null) {
            menuName = this.compositionLookupProperties.getProperty(key + TEXT, null);
            mnemonicKey = this.compositionLookupProperties.getProperty(key + MNEMONICKEY, null);
        }
        if (menuName == null) {
            menuName = "";
        }
        JMenu menu = new JMenu(menuName);
        if (null != mnemonicKey && mnemonicKey.length() > 0) {
            menu.setMnemonic(mnemonicKey.charAt(0));
        }
        ActionJCheckboxMenuItem chckMenu = null;
        ActionJRadioMenuItem radioMenu = null;
        ButtonGroup group = new ButtonGroup();
        Action action = null;
        ArrayList<String> subMenuCollection = new ArrayList<String>();
        String metaInfo = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            CommandAction ca;
            Object nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                metaInfo = (String)nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    String subMenuName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JMenu subMenu = null;
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + subMenuName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    subMenu = this.doCreateMenu(null, subMenuCollection, context, additionalActions);
                    if (subMenu != null) {
                        subMenu.setName(subMenuName);
                        subMenu.setText(subMenuName);
                        menu.add(subMenu);
                    }
                } else if (metaInfo.equals(SEPARATOR)) {
                    menu.addSeparator();
                } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    ActionFactory af = this.getActionFactory(metaInfo);
                    if (af != null || !DefaultMenuComponentFactory.isIgnoreEmptyActions()) {
                        action = af.getAction(context, metaInfo);
                    }
                }
            }
            if (null == action || DefaultMenuComponentFactory.isIgnoreEmptyActions() && action instanceof CommandAction && (ca = action).getCommands().size() == 1 && ca.getCommands().iterator().next() instanceof DummyCommand) continue;
            String menuType = (String)action.getValue("menuType");
            String menuState = (String)action.getValue("menuState");
            if (menuType != null && menuType.equals(CHECKBOX_MENU)) {
                chckMenu = new ActionJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_CHECKBOX_MENU)) {
                chckMenu = new VisibilityEnabledJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(RADIOBUTTON_MENU)) {
                radioMenu = new ActionJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_RADIOBUTTON_MENU)) {
                radioMenu = new VisibilityEnabledJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_MENU)) {
                menu.add(new VisibilityEnabledJMenuItem(action));
                continue;
            }
            menu.add(new IconJMenuItem(action, menuType != null && menuType.equals(ICON_MENU)));
        }
        return menu;
    }

    protected JPopupMenu doCreateContextMenu(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        ActionJCheckboxMenuItem chckMenu = null;
        ActionJRadioMenuItem radioMenu = null;
        JButtonGroup group = null;
        Action action = null;
        ArrayList<String> subMenuCollection = new ArrayList<String>();
        String metaInfo = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            Object nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                metaInfo = (String)nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    String subMenuName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JMenu subMenu = null;
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + subMenuName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    subMenu = this.doCreateMenu(null, subMenuCollection, context, additionalActions);
                    if (subMenu != null) {
                        subMenu.setName(subMenuName);
                        subMenu.setText(subMenuName);
                        menu.add(subMenu);
                    }
                } else if (metaInfo.equals(SEPARATOR)) {
                    menu.addSeparator();
                } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    action = this.getActionFactory(metaInfo).getAction(context, metaInfo);
                }
            }
            if (null == action) continue;
            String menuType = (String)action.getValue("menuType");
            String menuState = (String)action.getValue("menuState");
            if (menuType != null && menuType.equals(CHECKBOX_MENU)) {
                chckMenu = new ActionJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_CHECKBOX_MENU)) {
                chckMenu = new VisibilityEnabledJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(RADIOBUTTON_MENU)) {
                radioMenu = new ActionJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                if (group == null) {
                    group = new JButtonGroup();
                    menu.putClientProperty("ButtonGroup", group);
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_RADIOBUTTON_MENU)) {
                radioMenu = new VisibilityEnabledJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                if (group == null) {
                    group = new JButtonGroup();
                    menu.putClientProperty("ButtonGroup", group);
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_MENU)) {
                menu.add(new VisibilityEnabledJMenuItem(action));
                continue;
            }
            boolean withIcon = menuType != null && menuType.equals(ICON_MENU) || this.compositionLookupProperties.getPropertyAsBoolean(key + ".enableIcons", false);
            menu.add(new IconJMenuItem(action, withIcon));
        }
        return menu;
    }

    protected MenuComponentFactory getMenuFactory(String key) {
        String sourceName = null;
        String resourcePath = null;
        int index = key.indexOf(46);
        if (index < 0) {
            return this;
        }
        sourceName = key.substring(0, index - 1);
        resourcePath = this.compositionLookupProperties.getProperty("resource." + sourceName);
        return DefaultMenuComponentFactory.getInstance(resourcePath);
    }

    protected Collection getStructureOfActionNames(String key, String type) {
        String exp;
        int indexComma = key.indexOf(46);
        if (indexComma >= 0) {
            key = key.substring(0, indexComma - 1);
        }
        if ((exp = this.compositionLookupProperties.getProperty(key + ".actions" + type, null)) == null) {
            exp = this.compositionLookupProperties.getProperty(key + ".actions");
        }
        if (exp == null) {
            DefaultMenuComponentFactory.fireCreationWarning(this, "No structure definition found by " + this.getFactoryName(), key);
            return null;
        }
        StringTokenizer actionsToken = new StringTokenizer(exp, ",", false);
        ArrayList<String> actionsCollection = new ArrayList<String>();
        String token = null;
        ArrayList<String> nameOfSubmenu = new ArrayList<String>();
        while (actionsToken.hasMoreTokens()) {
            token = actionsToken.nextToken().trim();
            if (token == null || token.trim().length() == 0) continue;
            if (token.startsWith(VARIABLE)) {
                if (token.startsWith(SUBMENUVARIABLE)) {
                    token = token.substring(SUBMENUVARIABLE.length(), token.length() - 1).trim();
                    nameOfSubmenu.add(this.compositionLookupProperties.getProperty(token + TEXT, this.compositionLookupProperties.getProperty(token + SUBMENU_ACTION, "Not Found!")));
                    actionsCollection.add(STARTSUB + nameOfSubmenu.get(nameOfSubmenu.size() - 1));
                    Collection subMenu = null;
                    subMenu = this.getMenuFactory(token).getActionsForType(token, type);
                    if (subMenu != null) {
                        actionsCollection.addAll(subMenu);
                    }
                    actionsCollection.add(ENDSUB + nameOfSubmenu.get(nameOfSubmenu.size() - 1));
                    nameOfSubmenu.remove(nameOfSubmenu.size() - 1);
                    continue;
                }
                Collection anotherMenuPart = this.getMenuFactory(token = token.substring(VARIABLE.length(), token.length() - 1).trim()).getActionsForType(token, type);
                if (anotherMenuPart == null) continue;
                actionsCollection.addAll(anotherMenuPart);
                continue;
            }
            if (token.length() <= 0) continue;
            actionsCollection.add(token);
        }
        return actionsCollection;
    }

    protected void loadProperties(String propertiesFileName) throws IOException {
        this.compositionLookupProperties.load(propertiesFileName, this.getClass());
    }

    protected void loadProperties(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No properties stream available.");
        }
        this.compositionLookupProperties.load(is);
        is.close();
    }

    public JMenuBar getMenuBar(String key, Context context) {
        return this.doCreateMenuBar(key, this.getStructureOfActionNames(key, ".menu"), context, null);
    }

    protected JMenuBar doCreateMenuBar(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        String menuName = null;
        if (key != null && (menuName = this.compositionLookupProperties.getProperty(key + ".actions" + TEXT, null)) == null) {
            menuName = this.compositionLookupProperties.getProperty(key + TEXT, null);
        }
        if (menuName == null) {
            menuName = "";
        }
        JMenuBar menuBar = new JMenuBar();
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            Object nextIter = actionIterator.next();
            Action action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                String metaInfo = (String)nextIter;
                if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    String name = metaInfo.trim();
                    String menuTitle = this.compositionLookupProperties.getProperty(name + TEXT, menuName);
                    String mnemonic = this.compositionLookupProperties.getProperty(name + "." + "MnemonicKey", "").trim();
                    JMenu subMenu = this.doCreateMenu(name, this.getStructureOfActionNames(name, ".menu"), context, null);
                    if (subMenu != null) {
                        subMenu.setName(name);
                        subMenu.setText(menuTitle);
                        if (mnemonic.length() > 0) {
                            subMenu.setMnemonic(mnemonic.charAt(0));
                        }
                        menuBar.add(subMenu);
                    }
                }
            }
            if (null == action) continue;
            menuBar.add(new IconJMenuItem(action, true));
        }
        return menuBar;
    }

    public void putLookupProperty(String key, String value) {
        this.compositionLookupProperties.put((Object)key, (Object)value);
    }

    public String getLookupProperty(String key) {
        return (String)this.compositionLookupProperties.get((Object)key);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }
}

