/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.ContextEvent;
import com.levigo.util.swing.action.ContextListener;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CommandAction
extends AbstractAction
implements ContextListener {
    private static final long serialVersionUID = 1L;
    protected static final String CHECKED = "checked";
    private Collection commandList;
    private Context context;

    public CommandAction(Context context, Collection commands, String key, Object name, String shortDescription, String longDescription, Icon smallIcon, String actionCommandKey, KeyStroke acceleratorKey, int mnemonicKey, HashMap otherParameters) {
        this.context = context;
        this.commandList = commands;
        this.context.addContextChangeListener(this);
        this.putValue("Name", null != name ? name : (null != shortDescription ? shortDescription : ""));
        if (null != shortDescription) {
            this.putValue("ShortDescription", shortDescription);
        }
        if (null != longDescription) {
            this.putValue("LongDescription", longDescription);
        }
        if (null != smallIcon) {
            this.putValue("SmallIcon", smallIcon);
        }
        if (null != actionCommandKey) {
            this.putValue("ActionCommandKey", actionCommandKey);
        }
        if (null != acceleratorKey) {
            this.putValue("AcceleratorKey", acceleratorKey);
        }
        if (mnemonicKey > 0) {
            this.putValue("MnemonicKey", new Integer(mnemonicKey));
        }
        if (otherParameters != null && otherParameters.size() > 0) {
            Set keys = otherParameters.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String k = (String)iterator.next();
                if (k == null || k.length() <= 0) continue;
                this.putValue(k, otherParameters.get(k));
            }
        }
        this.updateEnableCheckState(context);
    }

    public void contextChanged(Context source) {
        this.updateEnableCheckState(source);
    }

    public void contextChanged(ContextEvent e) {
        this.updateEnableCheckState(e.getContext());
    }

    private void updateEnableCheckState(Context context) {
        Iterator it = this.commandList.iterator();
        boolean enabled = true;
        boolean checked = true;
        while (it.hasNext()) {
            Command command = (Command)it.next();
            if (!command.checkQuickly(context)) {
                enabled = false;
            }
            if (command.isChecked(context)) continue;
            checked = false;
        }
        this.setEnabled(enabled);
        this.setChecked(checked);
    }

    public void actionPerformed(ActionEvent e) {
        Iterator iterator = this.commandList.iterator();
        while (iterator.hasNext()) {
            ((Command)iterator.next()).execute(this.context);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.context.removeContextChangeListener(this);
    }

    public String toString() {
        return (String)this.getValue("ShortDescription");
    }

    public Collection getCommands() {
        return this.commandList;
    }

    public void setChecked(boolean newValue) {
        this.putValue(CHECKED, new Boolean(newValue));
    }
}

