/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.TGASwingUtil;
import com.levigo.util.swing.action.ContextEvent;
import com.levigo.util.swing.action.ContextListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class Context
extends AbstractCollection {
    private static final boolean DEBUG_MODE = false;
    private Border activeBorder = null;
    private Border inactiveBorder = null;
    public static String PROPERTY_KEY = "context";
    private Context parent;
    private boolean active;
    private Collection children = new ArrayList();
    private Context activeChild;
    private Collection contextObjects = new ArrayList();
    private JComponent owner;
    private int objectAggregation;
    public static final int NO_CHILDREN = 0;
    public static final int ACTIVE_CHILD = 1;
    public static final int ALL_CHILDREN = 2;
    public static final int ALL_PARENTS = 3;
    private Collection contextListeners = new ArrayList();
    private OwnerFocusListener ownerFocusListener = new OwnerFocusListener();
    private OwnerInternalFrameListener ownerInternalFrameListener = new OwnerInternalFrameListener();

    public static Context get(JComponent component) {
        while (null != component) {
            Context ctx = (Context)component.getClientProperty(PROPERTY_KEY);
            if (null != ctx) {
                return ctx;
            }
            component = (JComponent)component.getParent();
        }
        return null;
    }

    public static Context install(JComponent owner, int objectAggregation) {
        return new Context(owner, objectAggregation, true);
    }

    public Context(JComponent owner, int objectAggregation) {
        this(owner, objectAggregation, false);
    }

    public Context(JComponent owner, int objectAggregation, boolean autoManageHierarchy) {
        this.owner = owner;
        this.objectAggregation = objectAggregation;
        if (owner != null) {
            owner.putClientProperty(PROPERTY_KEY, this);
            owner.addFocusListener(this.ownerFocusListener);
            if (owner instanceof JTabbedPane) {
                TabbedPaneChangeListener tabbedPaneChangeListener = new TabbedPaneChangeListener();
                ((JTabbedPane)owner).addChangeListener(tabbedPaneChangeListener);
                ((JTabbedPane)owner).addContainerListener(tabbedPaneChangeListener);
            }
        }
        if (autoManageHierarchy) {
            Context parent;
            if (null == owner) {
                throw new IllegalArgumentException("A JComponent type owner is mandatory, when autoManageHierarchy is used");
            }
            Container parentContainer = owner.getParent();
            if (null != parentContainer && parentContainer instanceof JComponent && null != (parent = Context.get((JComponent)parentContainer))) {
                parent.addChildContext(this);
            }
            owner.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if (e.getID() == 1400 && (e.getChangeFlags() & 3L) != 0L) {
                        Context newParent;
                        if (e.getChanged() != Context.this.owner) {
                            return;
                        }
                        Context currentParent = Context.this.getParent();
                        Container newParentContainer = Context.this.owner.getParent();
                        if (newParentContainer != null && null != (newParent = Context.get((JComponent)newParentContainer)) && newParent != currentParent) {
                            newParent.addChildContext(Context.this);
                        }
                        Context.this.propagateDownwards();
                    }
                }
            });
        }
    }

    public Context(JInternalFrame owner, int objectAggregation) {
        this.owner = owner;
        this.objectAggregation = objectAggregation;
        if (owner != null) {
            owner.putClientProperty(PROPERTY_KEY, this);
            owner.addInternalFrameListener(this.ownerInternalFrameListener);
        }
    }

    public Collection getContextObjects() {
        return this;
    }

    public Iterator iterator() {
        if (this.objectAggregation == 3) {
            return new UpwardsIterator();
        }
        return new AggregateIterator();
    }

    public void addChildContext(Context child) {
        if (null == child) {
            return;
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setParent(this);
            if (child.isActive()) {
                if (this.activeChild != null) {
                    this.contextObjects.remove(this.activeChild);
                }
                this.activeChild = child;
            }
            if (null != this.owner && this.owner instanceof JTabbedPane) {
                this.selectActiveChildForJTabbedPane((JTabbedPane)this.owner);
            }
            if (this.objectAggregation == 2 || this.objectAggregation == 1 && child.isActive()) {
                this.contextObjects.add(child);
            }
            this.contextChanged();
        }
    }

    public void removeChildContext(Context child) {
        this.children.remove(child);
        child.setParent(null);
        this.contextObjects.remove(child);
        this.contextChanged();
    }

    private synchronized void fireContextChanged() {
        try {
            Iterator iterator = this.contextListeners.iterator();
            while (iterator.hasNext()) {
                ((ContextListener)iterator.next()).contextChanged(this);
            }
        }
        catch (ConcurrentModificationException e) {
            this.fireContextChanged();
        }
    }

    public synchronized void addContextChangeListener(ContextListener contextListener) {
        if (!this.contextListeners.contains(contextListener)) {
            this.contextListeners.add(contextListener);
        }
    }

    public synchronized void removeContextChangeListener(ContextListener contextListener) {
        if (this.contextListeners.contains(contextListener)) {
            this.contextListeners.remove(contextListener);
        }
    }

    public void contextChanged(ContextEvent e) {
        this.contextChanged();
    }

    public void contextChanged() {
        if (TGASwingUtil.isEventDispatchThread()) {
            this.propagateChange();
        } else {
            TGASwingUtil.invokeLater(new Runnable(){

                public void run() {
                    Context.this.propagateChange();
                }
            });
        }
    }

    private void propagateChange() {
        this.propagateUpwards();
        this.propagateDownwards();
    }

    private void propagateUpwards() {
        this.fireContextChanged();
        if (null != this.parent) {
            this.parent.propagateUpwards();
        }
    }

    private void propagateDownwards() {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            Context child = (Context)iter.next();
            child.propagateDownwards();
        }
        if (this.objectAggregation == 3) {
            this.fireContextChanged();
        }
    }

    public void replace(Collection c) {
        boolean didRemove = true;
        Iterator i = this.contextObjects.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (element instanceof Context) continue;
            i.remove();
            didRemove = true;
        }
        this.contextObjects.addAll(c);
        if (didRemove || c.size() > 0) {
            this.contextChanged();
        }
    }

    public void replace(Collection c, Class matchClass) {
        boolean didRemove = this.doRemoveByClass(matchClass);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (matchClass.isAssignableFrom(iter.next().getClass())) continue;
            iter.remove();
        }
        this.contextObjects.addAll(c);
        if (didRemove || c.size() > 0) {
            this.contextChanged();
        }
    }

    private boolean doRemoveByClass(Class matchClass) {
        boolean didRemove = false;
        Iterator i = this.contextObjects.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (!matchClass.isAssignableFrom(element.getClass()) || element instanceof Context) continue;
            i.remove();
            didRemove = true;
        }
        return didRemove;
    }

    public void replace(Object o, Class matchClass) {
        if (!matchClass.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("Match class must be assignable from object class");
        }
        Iterator i = this.contextObjects.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (!matchClass.isAssignableFrom(element.getClass()) || element instanceof Context) continue;
            i.remove();
        }
        this.contextObjects.add(o);
        this.contextChanged();
    }

    public void setContextObjects(Collection newActiveObjects) {
        this.replace(newActiveObjects);
    }

    public boolean add(Object o) {
        boolean result = this.contextObjects.add(o);
        if (result) {
            this.contextChanged();
        }
        return result;
    }

    public void clear() {
        boolean didRemove = false;
        Iterator i = this.contextObjects.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof Context) continue;
            i.remove();
            didRemove = true;
        }
        if (didRemove) {
            this.contextChanged();
        }
    }

    public boolean remove(Object o) {
        boolean result = this.contextObjects.remove(o);
        if (result) {
            this.contextChanged();
        }
        return result;
    }

    public boolean removeByClass(Class matchClass) {
        boolean result = this.doRemoveByClass(matchClass);
        if (result) {
            this.contextChanged();
        }
        return result;
    }

    public int size() {
        int size = 0;
        try {
            Iterator iter = this.contextObjects.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof Context && o != this) {
                    size += ((Collection)o).size();
                    continue;
                }
                ++size;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return size;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (null != this.parent) {
            this.parent.childActiveStatusChanged(this, active);
        }
        this.contextChanged();
    }

    private void childActiveStatusChanged(Context childContext, boolean isActive) {
        if (!this.children.contains(childContext)) {
            return;
        }
        if (isActive) {
            if (childContext != this.activeChild) {
                if (null != this.activeChild) {
                    this.activeChild.setActive(false);
                }
                if (this.objectAggregation == 1) {
                    if (null != this.activeChild) {
                        this.contextObjects.remove(this.activeChild);
                    }
                    this.contextObjects.add(childContext);
                }
                this.activeChild = childContext;
            }
            if (!this.active) {
                this.setActive(true);
            }
        }
        this.contextChanged();
    }

    protected Collection getChildren() {
        return this.children;
    }

    protected Collection getRegisteredListeners() {
        return this.contextListeners;
    }

    public JComponent getOwner() {
        return this.owner;
    }

    public String toString() {
        return "Context[" + this.owner.getClass().getName() + (this.objectAggregation == 2 ? "] (all)" : (this.objectAggregation == 1 ? "] (active)" : "] (none)"));
    }

    public Context getParent() {
        return this.parent;
    }

    private void setParent(Context parent) {
        Context oldParent = this.parent;
        this.parent = parent;
        if (null != oldParent && oldParent != parent) {
            oldParent.removeChildContext(this);
        }
    }

    public void removeFromParentsContext() {
        if (this.getOwner() != null) {
            for (Container container = this.getOwner().getParent(); container != null; container = container.getParent()) {
                JComponent component;
                Context context;
                if (!(container instanceof JComponent) || (context = (Context)(component = (JComponent)container).getClientProperty(PROPERTY_KEY)) == null) continue;
                context.removeChildContext(this);
                break;
            }
        }
    }

    public void addToParentsContext() {
        if (this.getOwner() != null) {
            for (Container container = this.getOwner().getParent(); container != null; container = container.getParent()) {
                JComponent component;
                Context context;
                if (!(container instanceof JComponent) || (context = (Context)(component = (JComponent)container).getClientProperty(PROPERTY_KEY)) == null) continue;
                context.addChildContext(this);
                break;
            }
        }
    }

    public Object getElementByClass(Class clazz) {
        Object testObject = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            testObject = iterator.next();
            if (testObject == null || !clazz.isAssignableFrom(testObject.getClass())) continue;
            return testObject;
        }
        return null;
    }

    public Collection getElementsByClass(Class clazz) {
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        Object testObject = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            testObject = iterator.next();
            if (testObject == null || !clazz.isAssignableFrom(testObject.getClass())) continue;
            resultCollection.add(testObject);
        }
        return resultCollection;
    }

    private void selectActiveChildForJTabbedPane(JTabbedPane pane) {
        Component activeComponent = pane.getSelectedComponent();
        if (null == activeComponent) {
            if (this.activeChild != null) {
                this.contextObjects.remove(this.activeChild);
                this.contextChanged();
            }
        } else {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                Context child = (Context)i.next();
                if (!this.componentIsDescendantOf(child.getOwner(), activeComponent)) continue;
                this.childActiveStatusChanged(child, true);
            }
            if (this.activeChild != null && !this.componentIsDescendantOf(this.activeChild.getOwner(), activeComponent)) {
                this.contextObjects.remove(this.activeChild);
                this.contextChanged();
            }
        }
    }

    private boolean componentIsDescendantOf(Component descendant, Component ancestor) {
        Component c;
        for (c = descendant; null != c && c != ancestor && c.getParent() != null; c = c.getParent()) {
        }
        return c == ancestor;
    }

    private class TabbedPaneChangeListener
    implements ChangeListener,
    ContainerListener {
        private TabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (Context.this.objectAggregation == 1) {
                Context.this.selectActiveChildForJTabbedPane((JTabbedPane)e.getSource());
            }
        }

        public void componentAdded(ContainerEvent e) {
            if (Context.this.objectAggregation == 1) {
                Context.this.selectActiveChildForJTabbedPane((JTabbedPane)e.getSource());
            }
        }

        public void componentRemoved(ContainerEvent e) {
            if (Context.this.objectAggregation == 1) {
                Context.this.selectActiveChildForJTabbedPane((JTabbedPane)e.getSource());
            }
        }
    }

    private class OwnerInternalFrameListener
    extends InternalFrameAdapter {
        private OwnerInternalFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            Context.this.setActive(true);
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            Context.this.setActive(false);
        }
    }

    private class OwnerFocusListener
    implements FocusListener {
        private OwnerFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Context.this.setActive(true);
        }

        public void focusLost(FocusEvent e) {
            Context.this.setActive(false);
        }
    }

    private class UpwardsIterator
    implements Iterator {
        private Iterator contextIterator;
        private Context target;
        private Object next;

        private UpwardsIterator() {
            this.target = Context.this;
            this.contextIterator = Context.this.contextObjects.iterator();
        }

        public boolean hasNext() {
            try {
                while (this.next == null) {
                    if (null != this.contextIterator && this.contextIterator.hasNext()) {
                        this.next = this.contextIterator.next();
                        continue;
                    }
                    if (null == this.target.parent) break;
                    this.target = this.target.parent;
                    this.contextIterator = this.target.contextObjects.iterator();
                }
                return null != this.next;
            }
            catch (ConcurrentModificationException e) {
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Tried to iterate over the end.");
            }
            Object tmp = this.next;
            this.next = null;
            return tmp;
        }

        public void remove() {
            throw new UnsupportedOperationException("Thou shalt not re-moo-ve something here.");
        }
    }

    private class AggregateIterator
    implements Iterator {
        private Iterator localIterator;
        private Iterator childIterator;
        private Object next;

        private AggregateIterator() {
            this.localIterator = Context.this.contextObjects.iterator();
        }

        public boolean hasNext() {
            try {
                while (this.next == null) {
                    if (null != this.childIterator) {
                        if (this.childIterator.hasNext()) {
                            this.next = this.childIterator.next();
                            continue;
                        }
                        this.childIterator = null;
                    }
                    if (null == this.localIterator || !this.localIterator.hasNext()) break;
                    this.next = this.localIterator.next();
                    if (!(this.next instanceof Context) || this.next == Context.this) continue;
                    this.childIterator = ((Context)this.next).iterator();
                    this.next = null;
                }
                return null != this.next;
            }
            catch (ConcurrentModificationException e) {
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Tried to iterate over the end.");
            }
            Object tmp = this.next;
            this.next = null;
            return tmp;
        }

        public void remove() {
            throw new UnsupportedOperationException("Thou shalt not re-moo-ve something here.");
        }
    }
}

