/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.ActionCreationListener;
import com.levigo.util.swing.action.BasicActionFactory;
import com.levigo.util.swing.action.CommandAction;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.NamedActionFactory;
import com.levigo.util.swing.action.ResourceLocator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DefaultActionFactory
implements NamedActionFactory {
    static final String DEFAULT_PROPERTIES_FILE = "actions.properties";
    private static HashMap actionFactoryCache = new HashMap();
    private static final ArrayList creationListenerList = new ArrayList();
    protected String factoryName;
    protected List linkedActionFactories = new ArrayList(5);

    public static void addActionCreationListener(ActionCreationListener listener) {
        if (listener != null && !creationListenerList.contains(listener)) {
            creationListenerList.add(listener);
        }
    }

    public static void removeActionCreationListener(ActionCreationListener listener) {
        if (listener != null && creationListenerList.contains(listener)) {
            creationListenerList.remove(listener);
        }
    }

    public static ActionCreationListener[] getActionCreationListener() {
        return creationListenerList.toArray(new ActionCreationListener[creationListenerList.size()]);
    }

    static void fireCreationFailure(NamedActionFactory source, String message, String key, Throwable t) {
        ActionCreationListener[] listeners = DefaultActionFactory.getActionCreationListener();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationFailure(source, message, key, t);
        }
    }

    static void fireCreationInformation(NamedActionFactory source, String message, String key) {
        ActionCreationListener[] listeners = DefaultActionFactory.getActionCreationListener();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationInformation(source, message, key);
        }
    }

    static void fireCreationWarning(NamedActionFactory source, String message, String key) {
        ActionCreationListener[] listeners = DefaultActionFactory.getActionCreationListener();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationWarning(source, message, key);
        }
    }

    public static DefaultActionFactory getInstance(String propertiesFileName) {
        DefaultActionFactory instance;
        if (propertiesFileName == null) {
            propertiesFileName = DEFAULT_PROPERTIES_FILE;
        }
        if (null == (instance = (DefaultActionFactory)actionFactoryCache.get(propertiesFileName))) {
            try {
                instance = new DefaultActionFactory(propertiesFileName);
            }
            catch (Exception exp) {
                DefaultActionFactory.fireCreationFailure(null, "Could not create DefaultActionFactory", propertiesFileName, exp);
                instance = null;
            }
            actionFactoryCache.put(propertiesFileName, instance);
        }
        return instance;
    }

    private DefaultActionFactory(String propertiesFileName) throws Exception {
        this.factoryName = propertiesFileName;
        this.initializeLinkedFactories(propertiesFileName);
    }

    private void initializeLinkedFactories(String propertiesFileName) {
        URL url = null;
        Iterator it = ResourceLocator.getResourceURLIterator(propertiesFileName);
        while (it.hasNext()) {
            try {
                url = (URL)it.next();
                BasicActionFactory factory = new BasicActionFactory(url.openStream(), url.toString());
                this.linkedActionFactories.add(factory);
            }
            catch (Throwable e) {
                DefaultActionFactory.fireCreationFailure(this, "Error occured while loading action factory resource", url.toString(), e);
            }
        }
    }

    public String getLinkedFactoryDescription() {
        NamedActionFactory[] factories = this.getLinkedActionFactories();
        String description = "DefaultActionFactory (" + this.getFactoryName() + "),\n\tlinked factories: ";
        for (int i = 0; i < factories.length; ++i) {
            description = description + "\n\t" + factories[i].getFactoryName() + (i != factories.length - 1 ? ", " : "");
        }
        return description;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    private DefaultActionFactory() throws Exception {
    }

    public void putLookupProperty(String key, String value) {
        if (this.linkedActionFactories.isEmpty()) {
            throw new IllegalStateException("No action resources available.");
        }
        BasicActionFactory factory = (BasicActionFactory)this.linkedActionFactories.get(0);
        factory.putLookupProperty(key, value);
    }

    public String getLookupProperty(String key) {
        String result = null;
        Iterator iter = this.linkedActionFactories.iterator();
        while (result == null && iter.hasNext()) {
            BasicActionFactory subFactory = (BasicActionFactory)iter.next();
            result = subFactory.getLookupProperty(key);
        }
        return result;
    }

    public CommandAction getAction(Context context, String key) {
        CommandAction anAction = null;
        NamedActionFactory[] factories = this.getLinkedActionFactories();
        for (int i = 0; anAction == null && i < factories.length; ++i) {
            anAction = factories[i].getAction(context, key);
        }
        if (anAction == null) {
            DefaultActionFactory.fireCreationFailure(this, "Action not found or not available by " + this.getFactoryName(), key, null);
        }
        return anAction;
    }

    public CommandAction getAction(Context context, String key, String commands, String shortDescription, String longDescription, Icon smallIcon, String actionCommandKey, KeyStroke acceleratorKey, int mnemonicKey, HashMap otherParameters) {
        CommandAction anAction = null;
        NamedActionFactory[] factories = this.getLinkedActionFactories();
        for (int i = 0; anAction == null && i < factories.length; ++i) {
            anAction = factories[i].getAction(context, key, commands, shortDescription, longDescription, smallIcon, actionCommandKey, acceleratorKey, mnemonicKey, otherParameters);
        }
        return anAction;
    }

    public CommandAction getAction(Context context, String key, String name, String commands, String shortDescription, String longDescription, Icon smallIcon, String actionCommandKey, KeyStroke acceleratorKey, int mnemonicKey, HashMap otherParameters) {
        CommandAction anAction = null;
        NamedActionFactory[] factories = this.getLinkedActionFactories();
        for (int i = 0; anAction == null && i < factories.length; ++i) {
            anAction = factories[i].getAction(context, key, name, commands, shortDescription, longDescription, smallIcon, actionCommandKey, acceleratorKey, mnemonicKey, otherParameters);
        }
        if (anAction == null) {
            DefaultActionFactory.fireCreationFailure(this, "Action not defined or not available", key, null);
        }
        return anAction;
    }

    public NamedActionFactory[] getLinkedActionFactories() {
        return this.linkedActionFactories.toArray(new NamedActionFactory[this.linkedActionFactories.size()]);
    }

    public void addLinkedActionFactory(BasicActionFactory actionFactory) {
        if (actionFactory == null) {
            return;
        }
        this.linkedActionFactories.remove(actionFactory);
        this.linkedActionFactories.add(actionFactory);
    }

    public void removeLinkedActionFactory(BasicActionFactory actionFactory) {
        if (actionFactory == null) {
            return;
        }
        this.linkedActionFactories.remove(actionFactory);
    }

    public void insertLinkedActionFactory(int index, BasicActionFactory actionFactory) {
        if (actionFactory == null) {
            return;
        }
        this.linkedActionFactories.remove(actionFactory);
        this.linkedActionFactories.add(index, actionFactory);
    }
}

