/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.BasicCommandFactory;
import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.CommandCreationListener;
import com.levigo.util.swing.action.NamedCommandFactory;
import com.levigo.util.swing.action.ResourceLocator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DefaultCommandFactory
implements NamedCommandFactory {
    static final String DEFAULT_PROPERTIES_FILE = "commands.properties";
    private static HashMap commandFactoryCache = new HashMap();
    private static final ArrayList creationListenerList = new ArrayList();
    protected String factoryName;
    protected List linkedCommandFactories = new ArrayList(5);

    public static void addCommandCreationListener(CommandCreationListener listener) {
        if (listener != null && !creationListenerList.contains(listener)) {
            creationListenerList.add(listener);
        }
    }

    public static void removeCommandCreationListener(CommandCreationListener listener) {
        if (listener != null && creationListenerList.contains(listener)) {
            creationListenerList.remove(listener);
        }
    }

    public static CommandCreationListener[] getCommandCreationListeners() {
        return creationListenerList.toArray(new CommandCreationListener[creationListenerList.size()]);
    }

    static void fireCreationFailure(NamedCommandFactory source, String message, String key, Throwable t) {
        CommandCreationListener[] listeners = DefaultCommandFactory.getCommandCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationFailure(source, message, key, t);
        }
    }

    static void fireCreationInformation(NamedCommandFactory source, String message, String key) {
        CommandCreationListener[] listeners = DefaultCommandFactory.getCommandCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationInformation(source, message, key);
        }
    }

    static void fireCreationWarning(NamedCommandFactory source, String message, String key) {
        CommandCreationListener[] listeners = DefaultCommandFactory.getCommandCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationWarning(source, message, key);
        }
    }

    public static DefaultCommandFactory getInstance(String propertiesFileName) {
        DefaultCommandFactory instance;
        if (propertiesFileName == null) {
            propertiesFileName = DEFAULT_PROPERTIES_FILE;
        }
        if (null == (instance = (DefaultCommandFactory)commandFactoryCache.get(propertiesFileName))) {
            try {
                instance = new DefaultCommandFactory(propertiesFileName);
            }
            catch (Exception exp) {
                DefaultCommandFactory.fireCreationFailure(null, "Could not create DefaultCommandFactory", propertiesFileName, exp);
                instance = null;
            }
            commandFactoryCache.put(propertiesFileName, instance);
        }
        return instance;
    }

    private DefaultCommandFactory(String propertiesFileName) {
        this.factoryName = propertiesFileName;
        this.initializeLinkedFactories(propertiesFileName);
    }

    private void initializeLinkedFactories(String propertiesFileName) {
        URL url = null;
        Iterator it = ResourceLocator.getResourceURLIterator(propertiesFileName);
        while (it.hasNext()) {
            try {
                url = (URL)it.next();
                BasicCommandFactory factory = new BasicCommandFactory(url.openStream(), url.toString());
                this.linkedCommandFactories.add(factory);
            }
            catch (Throwable e) {
                DefaultCommandFactory.fireCreationFailure(this, "Error occured while loading command factory resource", url.toString(), e);
            }
        }
    }

    private DefaultCommandFactory() {
    }

    public Command getCommand(String key) {
        Command aCommand = null;
        NamedCommandFactory[] factories = this.getLinkedCommandFactories();
        for (int i = 0; aCommand == null && i < factories.length; ++i) {
            aCommand = factories[i].getCommand(key);
        }
        if (aCommand == null) {
            DefaultCommandFactory.fireCreationFailure(this, "Command can not be created of " + this.getFactoryName(), key, null);
        }
        return aCommand;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getLinkedFactoryDescription() {
        NamedCommandFactory[] factories = this.getLinkedCommandFactories();
        String description = "DefaultCommandFactory (" + this.getFactoryName() + "),\n\tlinked factories: ";
        for (int i = 0; i < factories.length; ++i) {
            description = description + "\n\t" + factories[i].getFactoryName() + (i != factories.length - 1 ? ", " : "");
        }
        return description;
    }

    public void putLookupProperty(String key, String value) {
        if (this.linkedCommandFactories.isEmpty()) {
            throw new IllegalStateException("No command resources available.");
        }
        BasicCommandFactory factory = (BasicCommandFactory)this.linkedCommandFactories.get(0);
        factory.putLookupProperty(key, value);
    }

    public String getLookupProperty(String key) {
        String result = null;
        Iterator iter = this.linkedCommandFactories.iterator();
        while (result == null && iter.hasNext()) {
            BasicCommandFactory subFactory = (BasicCommandFactory)iter.next();
            result = subFactory.getLookupProperty(key);
        }
        return result;
    }

    public NamedCommandFactory[] getLinkedCommandFactories() {
        return this.linkedCommandFactories.toArray(new NamedCommandFactory[this.linkedCommandFactories.size()]);
    }

    public void addLinkedCommandFactory(BasicCommandFactory commandFactory) {
        if (commandFactory == null) {
            return;
        }
        this.linkedCommandFactories.remove(commandFactory);
        this.linkedCommandFactories.add(commandFactory);
    }

    public void removeLinkedCommandFactory(BasicCommandFactory commandFactory) {
        if (commandFactory == null) {
            return;
        }
        this.linkedCommandFactories.remove(commandFactory);
    }

    public void insertLinkedCommandFactory(int index, BasicCommandFactory commandFactory) {
        if (commandFactory == null) {
            return;
        }
        this.linkedCommandFactories.remove(commandFactory);
        this.linkedCommandFactories.add(index, commandFactory);
    }
}

