/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.BasicMenuComponentFactory;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.DefaultCommandFactory;
import com.levigo.util.swing.action.MenuComponentCreationListener;
import com.levigo.util.swing.action.NamedMenuComponentFactory;
import com.levigo.util.swing.action.ResourceLocator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class DefaultMenuComponentFactory
implements NamedMenuComponentFactory {
    private static boolean ignoreEmptyActions = false;
    private static HashMap menuComponentFactoryCache = new HashMap();
    static String DEFAULT_PROPERTIES_FILE = "menucomponents.properties";
    public static String COMPONENT_RESOURCE = "component_resource";
    public static String COMPONENT_KEY = "component_key";
    private static final ArrayList creationListenerList = new ArrayList();
    protected List linkedMenuComponentFactories = new ArrayList(5);
    protected String factoryName;

    public static void setIgnoreEmptyActions(boolean ignore) {
        ignoreEmptyActions = ignore;
    }

    public static boolean isIgnoreEmptyActions() {
        return ignoreEmptyActions;
    }

    public static void addMenuComponentCreationListener(MenuComponentCreationListener listener) {
        if (listener != null && !creationListenerList.contains(listener)) {
            creationListenerList.add(listener);
        }
    }

    public static void removeMenuComponentCreationListener(MenuComponentCreationListener listener) {
        if (listener != null && creationListenerList.contains(listener)) {
            creationListenerList.remove(listener);
        }
    }

    public static MenuComponentCreationListener[] getMenuComponentCreationListeners() {
        return creationListenerList.toArray(new MenuComponentCreationListener[creationListenerList.size()]);
    }

    static void fireCreationFailure(NamedMenuComponentFactory source, String message, String key, Throwable t) {
        MenuComponentCreationListener[] listeners = DefaultMenuComponentFactory.getMenuComponentCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationFailure(source, message, key, t);
        }
    }

    static void fireCreationInformation(NamedMenuComponentFactory source, String message, String key) {
        MenuComponentCreationListener[] listeners = DefaultMenuComponentFactory.getMenuComponentCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationInformation(source, message, key);
        }
    }

    static void fireCreationWarning(NamedMenuComponentFactory source, String message, String key) {
        MenuComponentCreationListener[] listeners = DefaultMenuComponentFactory.getMenuComponentCreationListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].creationWarning(source, message, key);
        }
    }

    public static DefaultMenuComponentFactory getInstance(String propertiesFileName) {
        DefaultMenuComponentFactory instance;
        if (propertiesFileName == null) {
            propertiesFileName = DEFAULT_PROPERTIES_FILE;
        }
        if (null == (instance = (DefaultMenuComponentFactory)menuComponentFactoryCache.get(propertiesFileName))) {
            try {
                instance = new DefaultMenuComponentFactory(propertiesFileName);
            }
            catch (Exception exp) {
                DefaultCommandFactory.fireCreationFailure(null, "Could not create DefaultMenuComponentFactory", propertiesFileName, exp);
                instance = null;
            }
            menuComponentFactoryCache.put(propertiesFileName, instance);
        }
        return instance;
    }

    private DefaultMenuComponentFactory(String propertiesFileName) throws Exception {
        this.factoryName = propertiesFileName;
        this.initializeLinkedFactories(propertiesFileName);
    }

    private DefaultMenuComponentFactory() {
    }

    private void initializeLinkedFactories(String propertiesFileName) {
        ResourceLocator.addLookupClassLoader(this.getClass().getClassLoader());
        URL url = null;
        Iterator it = ResourceLocator.getResourceURLIterator(propertiesFileName);
        while (it.hasNext()) {
            try {
                url = (URL)it.next();
                BasicMenuComponentFactory factory = new BasicMenuComponentFactory(url.openStream(), url.toString());
                this.linkedMenuComponentFactories.add(factory);
            }
            catch (Throwable e) {
                DefaultMenuComponentFactory.fireCreationFailure(this, "Error occured while loading menu component factory resource", url.toString(), e);
            }
        }
    }

    public String getLinkedFactoryDescription() {
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        String description = "DefaultMenuComponentFactory (" + this.getFactoryName() + "),\n\tlinked factories: ";
        for (int i = 0; i < factories.length; ++i) {
            description = description + "\n\t" + factories[i].getFactoryName() + (i != factories.length - 1 ? ", " : "");
        }
        return description;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public Collection getActions(String key) {
        Collection actions = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; (actions == null || actions.isEmpty()) && i < factories.length; ++i) {
            actions = factories[i].getActions(key);
        }
        return actions;
    }

    public Collection getCommandActions(String key, Context context) {
        Collection commandActions = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; (commandActions == null || commandActions.isEmpty()) && i < factories.length; ++i) {
            commandActions = factories[i].getCommandActions(key, context);
        }
        return commandActions;
    }

    public JPopupMenu getContextMenu(String key, Context context) {
        JPopupMenu popup = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; popup == null && i < factories.length; ++i) {
            popup = factories[i].getContextMenu(key, context);
            this.setResourceProperties(popup, key);
        }
        return popup;
    }

    public JPopupMenu getContextMenu(String key, Context context, Action[] additionalActions) {
        JPopupMenu popup = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; popup == null && i < factories.length; ++i) {
            popup = factories[i].getContextMenu(key, context, additionalActions);
            this.setResourceProperties(popup, key);
        }
        return popup;
    }

    public JMenu getMenu(String key, Context context) {
        JMenu menu = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; menu == null && i < factories.length; ++i) {
            menu = factories[i].getMenu(key, context);
            this.setResourceProperties(menu, key);
        }
        return menu;
    }

    public JMenu getMenu(String key, Context context, Action[] additionalActions) {
        JMenu menu = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; menu == null && i < factories.length; ++i) {
            menu = factories[i].getMenu(key, context, additionalActions);
            this.setResourceProperties(menu, key);
        }
        return menu;
    }

    public JToolBar getToolbar(String key, Context context) {
        JToolBar toolbar = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; toolbar == null && i < factories.length; ++i) {
            toolbar = factories[i].getToolbar(key, context);
            this.setResourceProperties(toolbar, key);
        }
        return toolbar;
    }

    private void setResourceProperties(JComponent component, String key) {
        if (component == null) {
            return;
        }
        component.putClientProperty(COMPONENT_RESOURCE, this.getFactoryName());
        component.putClientProperty(COMPONENT_KEY, key);
    }

    public JToolBar getToolbar(String key, Context context, Action[] additionalActions) {
        JToolBar toolbar = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; toolbar == null && i < factories.length; ++i) {
            toolbar = factories[i].getToolbar(key, context, additionalActions);
            this.setResourceProperties(toolbar, key);
        }
        return toolbar;
    }

    public JMenuBar getMenuBar(String key, Context context) {
        JMenuBar menubar = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; menubar == null && i < factories.length; ++i) {
            menubar = factories[i].getMenuBar(key, context);
            this.setResourceProperties(menubar, key);
        }
        return menubar;
    }

    public void putLookupProperty(String key, String value) {
        if (this.linkedMenuComponentFactories.isEmpty()) {
            throw new IllegalStateException("No menu component resources available.");
        }
        BasicMenuComponentFactory factory = (BasicMenuComponentFactory)this.linkedMenuComponentFactories.get(0);
        factory.putLookupProperty(key, value);
    }

    public String getLookupProperty(String key) {
        String result = null;
        Iterator iter = this.linkedMenuComponentFactories.iterator();
        while (result == null && iter.hasNext()) {
            BasicMenuComponentFactory subFactory = (BasicMenuComponentFactory)iter.next();
            result = subFactory.getLookupProperty(key);
        }
        return result;
    }

    public Collection getActionsForType(String key, String type) {
        Collection structureOfActions = null;
        NamedMenuComponentFactory[] factories = this.getLinkedMenuComponentFactories();
        for (int i = 0; (structureOfActions == null || structureOfActions.isEmpty()) && i < factories.length; ++i) {
            structureOfActions = factories[i].getActionsForType(key, type);
        }
        return structureOfActions;
    }

    public NamedMenuComponentFactory[] getLinkedMenuComponentFactories() {
        return this.linkedMenuComponentFactories.toArray(new NamedMenuComponentFactory[this.linkedMenuComponentFactories.size()]);
    }

    public void addLinkedMenuComponentFactory(BasicMenuComponentFactory menuComponentFactory) {
        if (menuComponentFactory == null) {
            return;
        }
        this.linkedMenuComponentFactories.remove(menuComponentFactory);
        this.linkedMenuComponentFactories.add(menuComponentFactory);
    }

    public void removeLinkedMenuComponentFactory(BasicMenuComponentFactory menuComponentFactory) {
        if (menuComponentFactory == null) {
            return;
        }
        this.linkedMenuComponentFactories.remove(menuComponentFactory);
    }

    public void insertLinkedMenuComponentFactory(int index, BasicMenuComponentFactory menuComponentFactory) {
        if (menuComponentFactory == null) {
            return;
        }
        this.linkedMenuComponentFactories.remove(menuComponentFactory);
        this.linkedMenuComponentFactories.add(index, menuComponentFactory);
    }
}

