/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class ResourceLocator {
    private static final List additionalClassLoaders = new ArrayList(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean removeLookupClassLoader(ClassLoader cl) {
        if (cl == null) {
            return false;
        }
        List list = additionalClassLoaders;
        synchronized (list) {
            return additionalClassLoaders.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addLookupClassLoader(ClassLoader cl) {
        if (cl == null) {
            return;
        }
        List list = additionalClassLoaders;
        synchronized (list) {
            if (!additionalClassLoaders.contains(cl)) {
                additionalClassLoaders.add(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getLookupClassLoaders() {
        List list = additionalClassLoaders;
        synchronized (list) {
            return Collections.unmodifiableList(additionalClassLoaders);
        }
    }

    static Iterator getResourceURLIterator(String resourceName) {
        return new ResourceIterator(resourceName);
    }

    private static final class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        public void remove() {
            throw new IllegalStateException("Empty Iterator");
        }
    }

    private static final class ResourceIterator
    implements Iterator {
        private Iterator allResources = null;

        private ResourceIterator(String resourceName) {
            this.initialize(resourceName);
        }

        private void initialize(String name) {
            if (name == null) {
                this.allResources = new EmptyIterator();
                return;
            }
            ArrayList resourceNames = new ArrayList();
            this.prepareNames(name, resourceNames);
            this.allResources = this.getURLIterator(resourceNames);
        }

        private Iterator getURLIterator(ArrayList resourceNames) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            Iterator iter = resourceNames.iterator();
            while (iter.hasNext()) {
                String resName = (String)iter.next();
                Enumeration<URL> resEnum = null;
                try {
                    resEnum = ClassLoader.getSystemResources(resName);
                }
                catch (IOException x) {
                    // empty catch block
                }
                if (resEnum != null) {
                    while (resEnum.hasMoreElements()) {
                        URL nextElement = resEnum.nextElement();
                        if (urlList.contains(nextElement)) continue;
                        urlList.add(nextElement);
                    }
                }
                this.prepareUrlsForClassLoader(Thread.currentThread().getContextClassLoader(), resName, urlList);
                Iterator classLoaderIter = ResourceLocator.getLookupClassLoaders().iterator();
                while (classLoaderIter.hasNext()) {
                    this.prepareUrlsForClassLoader((ClassLoader)classLoaderIter.next(), resName, urlList);
                }
            }
            return urlList.iterator();
        }

        private void prepareUrlsForClassLoader(ClassLoader loader, String name, ArrayList resourceList) {
            Enumeration<URL> resEnum = null;
            try {
                resEnum = loader.getResources(name);
            }
            catch (Exception x) {
                // empty catch block
            }
            if (resEnum != null) {
                while (resEnum.hasMoreElements()) {
                    URL nextElement = resEnum.nextElement();
                    if (resourceList.contains(nextElement)) continue;
                    resourceList.add(nextElement);
                }
            }
        }

        private void prepareNames(String name, ArrayList resourceNames) {
            String actualLanguage = Locale.getDefault().getLanguage();
            String fileName = name;
            String fileSuffix = null;
            int lastIndexOfSuffix = name.lastIndexOf(".");
            if (lastIndexOfSuffix >= 0) {
                fileSuffix = name.substring(lastIndexOfSuffix);
                fileName = name.substring(0, lastIndexOfSuffix);
            }
            this.resolveName(resourceNames, fileName + "_" + actualLanguage + (fileSuffix == null ? "" : fileSuffix));
            this.resolveName(resourceNames, name);
        }

        private List resolveName(List names, String name) {
            if (name == null) {
                return names;
            }
            names.add(name);
            if (!name.startsWith("/")) {
                Class<?> c = this.getClass();
                while (c.isArray()) {
                    c = c.getComponentType();
                }
                String baseName = c.getName();
                int index = baseName.lastIndexOf(46);
                if (index != -1) {
                    names.add(baseName.substring(0, index).replace('.', '/') + "/" + name);
                }
            } else {
                names.add(name.substring(1));
            }
            return names;
        }

        public boolean hasNext() {
            return this.allResources.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.allResources.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

