/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.overflow;

import com.levigo.util.swing.overflow.OverflowJMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;

public class OverflowJPopupMenu
extends JPopupMenu {
    private boolean shouldGetComponents = true;
    private Component[] myComponents = null;
    private JMenu overflowMenu;

    public OverflowJPopupMenu() {
        this.setLightWeightPopupEnabled(true);
    }

    public OverflowJPopupMenu(String label) {
        this();
    }

    public OverflowJPopupMenu(Component[] subComponents) {
        this();
        this.myComponents = subComponents;
        this.shouldGetComponents = false;
    }

    public static void main(String[] foo) {
        final JFrame f = new JFrame("Scrolling foo bar test");
        f.setSize(400, 400);
        final OverflowJPopupMenu spop = new OverflowJPopupMenu();
        for (int i = 0; i < 999; ++i) {
            JMenuItem lala = new JMenuItem("Item " + i);
            spop.add(lala);
        }
        f.setDefaultCloseOperation(2);
        f.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                spop.show(f, e.getX(), e.getY());
            }

            public void mouseReleased(MouseEvent e) {
                spop.show(f, e.getX(), e.getY());
            }
        });
        f.show();
    }

    public void addNotify() {
        super.addNotify();
        if (this.shouldGetComponents) {
            this.myComponents = this.getComponents();
            this.shouldGetComponents = false;
        }
    }

    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        Point where = new Point(x, y);
        SwingUtilities.convertPointToScreen(where, invoker);
        if (where.y < 0) {
            where.y = 0;
            this.setLocation(where.x, where.y);
        }
        Dimension scrn = this.computeScreenSize();
        int thisMenuSize = 0;
        for (int i = 0; i < this.myComponents.length; ++i) {
            Component curr = this.myComponents[i];
            if ((thisMenuSize += curr.getBounds().height) > scrn.height - where.y) {
                this.createOverflowMenu(i > 0 ? i - 1 : 0);
                break;
            }
            if (this.overflowMenu == null || i != this.myComponents.length - 1) continue;
            this.createOverflowMenu(this.myComponents.length);
        }
    }

    private Dimension computeScreenSize() {
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
        }
        Dimension scrn = new Dimension(screenBounds.width, screenBounds.height);
        return scrn;
    }

    private void createOverflowMenu(int pos) {
        if (null != this.overflowMenu) {
            this.remove(this.overflowMenu);
        }
        if (pos < this.myComponents.length) {
            this.overflowMenu = new OverflowJMenu("Mehr...");
            this.addPopupMenuListener((PopupMenuListener)((Object)this.overflowMenu));
            this.overflowMenu.removeAll();
            this.overflowMenu.add(new OverflowJPopupMenu());
            for (int i = pos; i < this.myComponents.length; ++i) {
                this.overflowMenu.add(this.myComponents[i]);
            }
            this.add(this.overflowMenu);
        }
        for (int j = 0; j < pos; ++j) {
            this.add(this.myComponents[j]);
        }
        this.validate();
        this.pack();
    }
}

