/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.EditableRowHeaderTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class EditableTableRowHeaderRenderer
extends JButton
implements TableCellRenderer {
    Icon fooIcon;
    private FakeButtonModel fbm = new FakeButtonModel();
    private int currentRow = -1;
    private JTable currentTable = null;

    public EditableTableRowHeaderRenderer(JTable table, boolean insertLine) {
        this(table);
    }

    public EditableTableRowHeaderRenderer(JTable table) {
        JTableHeader header = table.getTableHeader();
        this.setOpaque(true);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
        this.setForeground(header.getForeground());
        this.setBackground(header.getBackground());
        this.setFont(header.getFont());
        this.setModel(this.fbm);
        this.setText("");
        this.setIcon(new RowHeaderIcon(this.getForeground()));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.currentRow = row;
        this.currentTable = table;
        this.fbm.setActivated(this.isFullRowSelected());
        return this;
    }

    protected boolean isRowSelected() {
        boolean rowSelected = false;
        int[] selectedRows = this.currentTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length && !rowSelected; ++i) {
            rowSelected = selectedRows[i] == this.currentRow;
        }
        return rowSelected;
    }

    protected boolean isFullRowSelected() {
        return this.isRowSelected() && (this.currentTable.getSelectedColumnCount() == this.currentTable.getColumnCount() || this.currentTable.getSelectedRowCount() > 1);
    }

    protected boolean isEntryRow() {
        if (this.currentTable.getModel() instanceof EditableRowHeaderTableModel) {
            return ((EditableRowHeaderTableModel)((Object)this.currentTable.getModel())).isEntryRow(this.currentRow);
        }
        return false;
    }

    protected boolean isRowLocked() {
        if (this.currentTable.getModel() instanceof EditableRowHeaderTableModel) {
            return ((EditableRowHeaderTableModel)((Object)this.currentTable.getModel())).isRowLocked(this.currentRow);
        }
        return false;
    }

    private static class RowHeaderIcon
    implements Icon,
    UIResource,
    Serializable {
        private Icon currentRowMarkerIcon = IconManager.getInstance(this.getClass(), "icons").getIcon("currentRowMarker");
        private Icon entryRowMarkerIcon = IconManager.getInstance(this.getClass(), "icons").getIcon("entryRowMarker");
        private Icon lockedRowMarkerIcon = IconManager.getInstance(this.getClass(), "icons").getIcon("lockedRowMarker");

        RowHeaderIcon(Color foregound) {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            EditableTableRowHeaderRenderer r = (EditableTableRowHeaderRenderer)c;
            if (r.isRowLocked()) {
                this.lockedRowMarkerIcon.paintIcon(c, g, x, y);
            } else if (r.isRowSelected() && !r.isFullRowSelected() && !r.isEntryRow()) {
                this.currentRowMarkerIcon.paintIcon(c, g, x, y);
            } else if (r.isEntryRow()) {
                this.entryRowMarkerIcon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.currentRowMarkerIcon.getIconWidth();
        }

        public int getIconHeight() {
            return this.currentRowMarkerIcon.getIconHeight();
        }
    }

    class FakeButtonModel
    extends DefaultButtonModel {
        private boolean activated = false;

        FakeButtonModel() {
        }

        public boolean isPressed() {
            return this.activated;
        }

        public boolean isArmed() {
            return this.activated;
        }

        public void setActivated(boolean activated) {
            this.activated = activated;
        }
    }
}

