/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    private int pressedColumn = -1;
    private BevelArrowIcon downIcon;
    private BevelArrowIcon upIcon;

    public SortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), 0, font.getSize()));
        this.downIcon = new BevelArrowIcon(1);
        this.upIcon = new BevelArrowIcon(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumnIndex;
        SortableTableModel stm = (SortableTableModel)table.getModel();
        int direction = stm.getSortDirection(modelColumnIndex = table.convertColumnIndexToModel(column));
        if (direction > 0) {
            this.setIcon(this.downIcon);
            this.downIcon.setSortPriority(stm.getSortPriority(modelColumnIndex) + 1);
        } else if (direction < 0) {
            this.setIcon(this.upIcon);
            this.upIcon.setSortPriority(stm.getSortPriority(modelColumnIndex) + 1);
        } else {
            this.setIcon(null);
        }
        this.setHorizontalAlignment(Number.class.isAssignableFrom(table.getModel().getColumnClass(modelColumnIndex)) ? 4 : 2);
        this.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pressedColumn;
        this.getModel().setPressed(isPressed);
        this.getModel().setArmed(isPressed);
        return this;
    }

    public void setPressedColumn(int col) {
        this.pressedColumn = col;
    }

    private class BevelArrowIcon
    implements Icon {
        public static final int UP = 0;
        public static final int DOWN = 1;
        private Color controlDkShadow = UIManager.getColor("controlDkShadow");
        private Dimension size;
        private int direction;
        private int sortPriority;
        private Rectangle2D stringBounds;
        private LineMetrics lineMetrics;
        private Polygon downArrow;
        private Polygon upArrow;

        public BevelArrowIcon(int direction) {
            this.direction = direction;
            this.stringBounds = SortButtonRenderer.this.getFont().getStringBounds("2", new FontRenderContext(null, false, false));
            this.lineMetrics = SortButtonRenderer.this.getFont().getLineMetrics("2", new FontRenderContext(null, false, false));
            this.size = new Dimension(2 * (int)this.stringBounds.getWidth() + 1, Math.max((int)this.stringBounds.getWidth(), (int)this.stringBounds.getHeight()));
            int arrowWidth = (int)this.stringBounds.getWidth();
            if (arrowWidth % 2 == 0) {
                --arrowWidth;
            }
            int w2 = arrowWidth / 2;
            int x1 = arrowWidth - 1;
            int y0 = (this.size.height - w2) / 2 - 1;
            this.downArrow = new Polygon();
            this.downArrow.addPoint(0, y0);
            this.downArrow.addPoint(x1, y0);
            this.downArrow.addPoint(w2, w2 + y0);
            this.upArrow = new Polygon();
            this.upArrow.addPoint(0, w2 + y0);
            this.upArrow.addPoint(x1, w2 + y0);
            this.upArrow.addPoint(w2, y0);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.controlDkShadow);
            g.translate(x, y);
            g.drawPolygon(this.direction == 1 ? this.downArrow : this.upArrow);
            g.fillPolygon(this.direction == 1 ? this.downArrow : this.upArrow);
            if (this.getSortPriority() > 0) {
                g.drawString(Integer.toString(this.getSortPriority()), (int)this.stringBounds.getWidth() + 1, (int)this.lineMetrics.getAscent());
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size.width;
        }

        public int getIconHeight() {
            return this.size.height;
        }

        public void setSortPriority(int priority) {
            this.sortPriority = priority;
        }

        public int getSortPriority() {
            return this.sortPriority;
        }
    }
}

