/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.TGASwingUtil;
import com.levigo.util.swing.table.JTableRowHeader;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableRowHeaderUI
extends TableHeaderUI {
    private static final int AUTOSCROLL_INCREMENT = 5;
    private static final int AUTOSCROLL_DELAY = 10;
    protected JTableRowHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent h) {
        return new TableRowHeaderUI();
    }

    public void installUI(JComponent c) {
        this.header = (JTableRowHeader)c;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics g, JComponent c) {
        int rowHeight;
        if (this.header.getTableModel().getRowCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        TableModel cm = this.header.getTableModel();
        int rMin = this.getRowIndexAtY(clip.y);
        int rMax = this.getRowIndexAtY(clip.y + clip.height - 1);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1 || rMax >= cm.getRowCount()) {
            rMax = cm.getRowCount() - 1;
        }
        Rectangle cellRect = this.header.getHeaderRect(rMin);
        cellRect.height = rowHeight = this.header.getCellHeight();
        for (int row = rMin; row <= rMax; ++row) {
            this.paintCell(g, cellRect, row, this.header.getTable(), this.header.getDefaultRenderer());
            cellRect.y += rowHeight;
        }
        this.rendererPane.removeAll();
    }

    private int getRowIndexAtY(int y) {
        return this.header.rowAtPoint(new Point(0, y));
    }

    private void paintCell(Graphics g, Rectangle cellRect, int rowIndex, JTable table, TableCellRenderer renderer) {
        Component component = renderer.getTableCellRendererComponent(table, null, false, false, rowIndex, -1);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int getHeaderWidth() {
        TableModel model = this.header.getTableModel();
        Component comp = this.header.getDefaultRenderer().getTableCellRendererComponent(this.header.getTable(), null, false, false, model.getRowCount(), -1);
        return comp.getPreferredSize().height;
    }

    private Dimension createHeaderSize(long height) {
        if (height > Integer.MAX_VALUE) {
            height = Integer.MAX_VALUE;
        }
        return new Dimension(this.getHeaderWidth(), (int)height);
    }

    public Dimension getMinimumSize(JComponent c) {
        long height = this.header.getCellHeight() * this.header.getTableModel().getRowCount();
        return this.createHeaderSize(height);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int lastEffectiveMouseY;
        private int resizeStartHeight = -1;
        private int rowSelectStart = -1;
        private AutoScroller autoScroller = null;

        public void mouseClicked(MouseEvent e) {
            int row = TableRowHeaderUI.this.getRowIndexAtY(e.getPoint().y);
            if (TableRowHeaderUI.this.header.getTable().getRowCount() > row) {
                TableRowHeaderUI.this.header.getTable().setRowSelectionInterval(row, row);
                TableRowHeaderUI.this.header.getTable().setColumnSelectionInterval(0, TableRowHeaderUI.this.header.getTableModel().getColumnCount() - 1);
            }
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            this.lastEffectiveMouseY = p.y;
            if (this.isResize(this.lastEffectiveMouseY)) {
                this.resizeStartHeight = TableRowHeaderUI.this.header.getTable().getRowHeight();
                this.rowSelectStart = -1;
            } else {
                this.resizeStartHeight = -1;
                this.rowSelectStart = TableRowHeaderUI.this.getRowIndexAtY(p.y);
                int row = TableRowHeaderUI.this.getRowIndexAtY(e.getPoint().y);
                if (TableRowHeaderUI.this.header.getTable().getRowCount() > row) {
                    TableRowHeaderUI.this.header.getTable().setRowSelectionInterval(row, row);
                    TableRowHeaderUI.this.header.getTable().setColumnSelectionInterval(0, TableRowHeaderUI.this.header.getTableModel().getColumnCount() - 1);
                }
            }
        }

        private void setCursor(Cursor c) {
            if (TableRowHeaderUI.this.header.getCursor() != c) {
                TableRowHeaderUI.this.header.setCursor(c);
            }
        }

        private boolean isResize(int y) {
            int cellHeight = TableRowHeaderUI.this.header.getCellHeight();
            int cellRelativeY = y % cellHeight;
            return cellRelativeY < 2 || cellRelativeY >= cellHeight - 2;
        }

        public void mouseMoved(MouseEvent e) {
            if (TableRowHeaderUI.this.header.getResizingAllowed() && this.isResize(e.getPoint().y)) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseDragged(MouseEvent e) {
            int mouseY = e.getY();
            int deltaY = mouseY - this.lastEffectiveMouseY;
            if (deltaY == 0) {
                return;
            }
            if (this.resizeStartHeight >= 0) {
                int newRowHeight = this.resizeStartHeight + deltaY;
                if (newRowHeight < 2) {
                    newRowHeight = 2;
                }
                TableRowHeaderUI.this.header.getTable().setRowHeight(newRowHeight);
                TableRowHeaderUI.this.header.resizeAndRepaint();
            }
            Rectangle visible = TableRowHeaderUI.this.header.getVisibleRect();
            if (this.rowSelectStart >= 0) {
                int row = TableRowHeaderUI.this.getRowIndexAtY(e.getPoint().y);
                if (row >= TableRowHeaderUI.this.header.getTable().getRowCount()) {
                    row = TableRowHeaderUI.this.header.getTable().getRowCount() - 1;
                }
                if (row < 0) {
                    row = 0;
                }
                if (TableRowHeaderUI.this.header.getTable().getRowCount() > this.rowSelectStart) {
                    TableRowHeaderUI.this.header.getTable().setRowSelectionInterval(this.rowSelectStart, row);
                    TableRowHeaderUI.this.header.getTable().setColumnSelectionInterval(0, TableRowHeaderUI.this.header.getTableModel().getColumnCount() - 1);
                }
                if (mouseY > visible.y + visible.height) {
                    if (null == this.autoScroller) {
                        this.autoScroller = new AutoScroller();
                    }
                    this.autoScroller.setDirectionDown(true);
                }
                if (mouseY < visible.y) {
                    if (null == this.autoScroller) {
                        this.autoScroller = new AutoScroller();
                    }
                    this.autoScroller.setDirectionDown(false);
                }
            }
            if (null != this.autoScroller && mouseY <= visible.height + visible.y && mouseY >= visible.y) {
                this.autoScroller.goAway();
                this.autoScroller = null;
            }
        }

        private void scrollTableVertical(boolean down) {
            Rectangle visible = TableRowHeaderUI.this.header.getTable().getVisibleRect();
            visible.translate(0, down ? 5 : -5);
            TableRowHeaderUI.this.header.getTable().scrollRectToVisible(visible);
            if (this.rowSelectStart >= 0) {
                int row = TableRowHeaderUI.this.getRowIndexAtY(down ? TableRowHeaderUI.this.header.getVisibleRect().y + TableRowHeaderUI.this.header.getVisibleRect().height : TableRowHeaderUI.this.header.getVisibleRect().y);
                if (row >= TableRowHeaderUI.this.header.getTable().getRowCount()) {
                    row = TableRowHeaderUI.this.header.getTable().getRowCount() - 1;
                }
                if (row < 0) {
                    row = 0;
                }
                TableRowHeaderUI.this.header.getTable().setRowSelectionInterval(this.rowSelectStart, row);
                TableRowHeaderUI.this.header.getTable().setColumnSelectionInterval(0, TableRowHeaderUI.this.header.getTableModel().getColumnCount() - 1);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (null != this.autoScroller) {
                this.autoScroller.goAway();
                this.autoScroller = null;
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private class AutoScroller
        extends Thread {
            private boolean directionDown = true;
            private boolean goAway = false;

            public AutoScroller() {
                new Thread(this);
                this.setDaemon(true);
                this.start();
            }

            public void run() {
                while (!this.goAway) {
                    try {
                        TGASwingUtil.invokeAndWait(new Runnable(){

                            public void run() {
                                MouseInputHandler.this.scrollTableVertical(AutoScroller.this.directionDown);
                            }
                        });
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public void goAway() {
                this.goAway = true;
            }

            public void setDirectionDown(boolean down) {
                this.directionDown = down;
            }
        }
    }
}

