/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericDocument
extends PlainDocument {
    private int minimumValue;
    private int maximumValue;
    private int actualValue = 0;
    private boolean checkingEnabled = true;

    public NumericDocument(int min, int max) {
        this.minimumValue = min;
        this.maximumValue = max;
        this.setCheckingEnabled(this.minimumValue <= this.maximumValue);
    }

    public int getIntegerValue() {
        return this.actualValue;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (!this.checkingEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String proposedResult = null;
        if (this.getLength() == 0) {
            proposedResult = str;
        } else {
            StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
            currentBuffer.insert(offs, str);
            proposedResult = currentBuffer.toString();
        }
        try {
            this.actualValue = this.parse(proposedResult);
            super.insertString(offs, str, a);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (!this.checkingEnabled) {
            super.remove(offs, len);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = beforeOffset + afterOffset;
        try {
            this.actualValue = proposedResult.equals("") ? 0 : this.parse(proposedResult);
            super.remove(offs, len);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int parse(String proposedResult) throws NumberFormatException {
        int value = 0;
        if (proposedResult.length() != 0) {
            value = Integer.parseInt(proposedResult);
        }
        if (value >= this.minimumValue && value <= this.maximumValue) {
            return value;
        }
        throw new NumberFormatException();
    }

    public boolean isCheckingEnabled() {
        return this.checkingEnabled;
    }

    public void setCheckingEnabled(boolean checkingEnabled) {
        this.checkingEnabled = checkingEnabled;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }
}

