/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.util.http.impl;

import com.google.common.base.Strings;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.HttpAccessor;

public abstract class AbstractHttpAccessorBase
extends HttpAccessor {
    private String userAgent;

    public AbstractHttpAccessorBase(NetworkConfiguration.ProxyConfiguration proxyConfig, String userAgent) {
        this.userAgent = userAgent;
        this.setupHttpClient(proxyConfig);
    }

    public void setupHttpClient(NetworkConfiguration.ProxyConfiguration proxyConfig) {
        CloseableHttpClient httpClient;
        if (proxyConfig != null && proxyConfig.isEnabled()) {
            HttpClientBuilder builder = HttpClients.custom().setProxy(new HttpHost(proxyConfig.getHost(), proxyConfig.getPort()));
            builder.setUserAgent(this.userAgent);
            String proxyUser = proxyConfig.getUser();
            String proxyPassword = proxyConfig.getPassword();
            if (!Strings.isNullOrEmpty((String)proxyUser) || !Strings.isNullOrEmpty((String)proxyPassword)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyConfig.getHost(), proxyConfig.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            httpClient = builder.build();
        } else {
            httpClient = HttpClients.createDefault();
        }
        this.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
    }
}

