/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard;

import com.vaadin.spring.annotation.EnableVaadin;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.spring.boot.annotation.EnableVaadinServlet;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openthinclient.advisor.check.CheckExecutionEngine;
import org.openthinclient.advisor.inventory.SystemInventory;
import org.openthinclient.advisor.inventory.SystemInventoryFactory;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.web.WebUtil;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.FirstStartWizardUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableVaadin
@EnableVaadinServlet
@Import(value={EmbeddedServletContainerAutoConfiguration.class, MinimalWebMvcConfiguration.class})
@PropertySource(value={"classpath:/application.properties"})
public class WizardApplicationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WizardApplicationConfiguration.class);
    @Autowired
    ApplicationContext applicationContext;
    @Value(value="${vaadin.servlet.urlMapping}")
    private String vaadinServletUrlMapping;
    @Value(value="${otc.manager.installation.freespace.minimum}")
    private int installationFreespaceMinimum;

    @Bean
    public FilterRegistrationBean redirectToWizardFilter() {
        FilterRegistrationBean redirectFilter = new FilterRegistrationBean();
        redirectFilter.addUrlPatterns(new String[]{"/"});
        redirectFilter.setFilter((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                response.sendRedirect(WebUtil.getServletMappingRoot((String)WizardApplicationConfiguration.this.vaadinServletUrlMapping) + "first-start");
            }
        });
        return redirectFilter;
    }

    @Bean
    public AsyncListenableTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setMaxPoolSize(2);
        return taskExecutor;
    }

    @Bean
    public CheckExecutionEngine checkExecutionEngine(AsyncListenableTaskExecutor taskExecutor) {
        return new CheckExecutionEngine(taskExecutor);
    }

    @Bean
    public SystemInventoryFactory systemInventoryFactory() {
        return new SystemInventoryFactory(this.taskExecutor());
    }

    @Bean
    public FactoryBean<SystemInventory> systemInventoryFactoryBean() {
        SystemInventoryFactory systemInventoryFactory = this.systemInventoryFactory();
        ListenableFuture systemInventoryFuture = systemInventoryFactory.determineSystemInventory();
        return new SystemInventoryFactoryBean((ListenableFuture<SystemInventory>)systemInventoryFuture);
    }

    @Bean
    public ManagerHomeFactory managerHomeFactory() {
        return new ManagerHomeFactory();
    }

    @Bean
    public SystemSetupModel systemSetupModel(ManagerHomeFactory managerHomeFactory, SystemInventory systemInventory, CheckExecutionEngine checkExecutionEngine, AsyncListenableTaskExecutor taskExecutor) {
        SystemSetupModel model = new SystemSetupModel(managerHomeFactory, systemInventory, checkExecutionEngine, this.applicationContext, taskExecutor, this.installationFreespaceMinimum);
        model.setInstallationResume(InstallationDirectoryUtil.existsInstallationProgressFile((File)managerHomeFactory.getManagerHomeDirectory()));
        return model;
    }

    @Bean
    @UIScope
    public FirstStartWizardUI firstStartWizardUI() {
        return new FirstStartWizardUI();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfig() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Configuration
    @EnableWebMvc
    public static class MinimalWebMvcConfiguration {
        @Autowired
        WebApplicationContext applicationContext;

        @Bean
        public ServletRegistrationBean dispatcherRegistration() {
            ServletRegistrationBean reg = new ServletRegistrationBean();
            reg.addUrlMappings(new String[]{"/"});
            reg.setServlet((Servlet)new DispatcherServlet(this.applicationContext));
            return reg;
        }

        @Bean
        public WebMvcConfigurerAdapter staticResourcesConfigurer() {
            return new WebMvcConfigurerAdapter(){

                public void addResourceHandlers(ResourceHandlerRegistry registry) {
                    registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/public/"});
                }
            };
        }
    }

    private static class SystemInventoryFactoryBean
    extends AbstractFactoryBean<SystemInventory> {
        private final ListenableFuture<SystemInventory> systemInventoryFuture;
        private SystemInventory systemInventory;

        public SystemInventoryFactoryBean(ListenableFuture<SystemInventory> systemInventoryFuture) {
            this.setSingleton(true);
            this.systemInventoryFuture = systemInventoryFuture;
        }

        public Class<?> getObjectType() {
            return SystemInventory.class;
        }

        protected SystemInventory createInstance() throws Exception {
            if (this.systemInventory == null) {
                this.systemInventory = (SystemInventory)this.systemInventoryFuture.get();
            }
            return this.systemInventory;
        }
    }
}

