/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.service.nfs.NFSExport;
import org.openthinclient.service.nfs.NFSServiceConfiguration;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;

public class ConfigureNFSInstallStep
extends AbstractInstallStep {
    public static void main(String[] args) {
        ConfigureNFSInstallStep step = new ConfigureNFSInstallStep();
        InstallContext context = new InstallContext();
        context.setManagerHome(new ManagerHomeFactory().create());
        step.execute(context);
    }

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        ManagerHome managerHome = installContext.getManagerHome();
        NFSServiceConfiguration nfsServiceConfiguration = (NFSServiceConfiguration)managerHome.getConfiguration(NFSServiceConfiguration.class);
        if (!this.containsExport(nfsServiceConfiguration, "/openthinclient")) {
            nfsServiceConfiguration.getExports().add((Object)this.createExport(managerHome, "/openthinclient", Paths.get("nfs", "root")));
        } else {
            this.log.info("Skipping /openthinclient export. Such an export already exists");
        }
        if (!this.containsExport(nfsServiceConfiguration, "/home")) {
            nfsServiceConfiguration.getExports().add((Object)this.createExport(managerHome, "/home", Paths.get("nfs", "home")));
        } else {
            this.log.info("Skipping /home export. Such an export already exists");
        }
        this.log.info("Listing all configured exports...");
        nfsServiceConfiguration.getExports().forEach(export -> {
            this.log.info("Export {}", export);
            if (!export.getRoot().exists()) {
                this.log.info("Root directory doesn't exist: '{}'. Directory will be created.", (Object)export.getRoot());
                export.getRoot().mkdirs();
            }
        });
        managerHome.save(NFSServiceConfiguration.class);
    }

    private boolean containsExport(NFSServiceConfiguration nfsServiceConfiguration, String exportName) {
        return nfsServiceConfiguration.getExports().stream().filter(export -> export.getName().equals(exportName)).findFirst().isPresent();
    }

    private NFSExport createExport(ManagerHome managerHome, String name, Path relativePath) {
        NFSExport export = new NFSExport();
        export.setName(name);
        File root = managerHome.getLocation().toPath().resolve(relativePath).toFile();
        export.setRoot(root);
        NFSExport.Group wildcardGroup = this.createWildcardGroup();
        export.getGroups().add(wildcardGroup);
        return export;
    }

    private NFSExport.Group createWildcardGroup() {
        NFSExport.Group wildcardGroup = new NFSExport.Group();
        wildcardGroup.setWildcard(true);
        wildcardGroup.setReadOnly(false);
        return wildcardGroup;
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_CONFIGURENFSINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }
}

