/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import org.openthinclient.DownloadManagerFactory;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.db.DatabaseConfiguration;
import org.openthinclient.db.conf.DataSourceConfiguration;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerFactory;
import org.openthinclient.pkgmgr.spring.PackageManagerExecutionEngineConfiguration;
import org.openthinclient.pkgmgr.spring.PackageManagerFactoryConfiguration;
import org.openthinclient.pkgmgr.spring.PackageManagerRepositoryConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.openthinclient.wizard.model.DatabaseModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

public class PrepareDatabaseInstallStep
extends AbstractInstallStep {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareDatabaseInstallStep.class);
    private final DatabaseModel databaseModel;

    public PrepareDatabaseInstallStep(DatabaseModel databaseModel) {
        this.databaseModel = databaseModel;
    }

    public static void apply(DatabaseConfiguration target, DatabaseModel model) {
        target.setType(model.getType());
        if (model.getType() == DatabaseConfiguration.DatabaseType.MYSQL) {
            DatabaseModel.MySQLConfiguration mySQLConfiguration = model.getMySQLConfiguration();
            target.setUrl("jdbc:mysql://" + mySQLConfiguration.getHostname() + ":" + mySQLConfiguration.getPort() + "/" + mySQLConfiguration.getDatabase());
            target.setUsername(mySQLConfiguration.getUsername());
            target.setPassword(mySQLConfiguration.getPassword());
        } else if (model.getType() == DatabaseConfiguration.DatabaseType.H2) {
            target.setUrl(null);
            target.setUsername("sa");
            target.setPassword("");
        } else if (model.getType() == DatabaseConfiguration.DatabaseType.APACHE_DERBY) {
            target.setUrl(null);
            target.setUsername("sa");
            target.setPassword("");
        } else {
            throw new IllegalArgumentException("Unsupported type of database " + model.getType());
        }
    }

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        ManagerHome managerHome = installContext.getManagerHome();
        DatabaseConfiguration target = (DatabaseConfiguration)managerHome.getConfiguration(DatabaseConfiguration.class);
        DatabaseModel.apply(this.databaseModel, target);
        managerHome.save(DatabaseConfiguration.class);
        LOG.info("Preparing database bootstrap");
        AnnotationConfigApplicationContext context = this.createDatabaseInitApplicationContext(installContext);
        context.refresh();
        context.close();
        LOG.info("Database bootstrap completed");
        LOG.info("Preparing package manager aware application context");
        context = this.createPackageManagerApplicationContext(installContext);
        context.refresh();
        PackageManager packageManager = ((PackageManagerFactory)context.getBean(PackageManagerFactory.class)).createPackageManager((PackageManagerConfiguration)installContext.getManagerHome().getConfiguration(PackageManagerConfiguration.class));
        installContext.setPackageManager(packageManager);
        installContext.setContext((ConfigurableApplicationContext)context);
    }

    private AnnotationConfigApplicationContext createPackageManagerApplicationContext(InstallContext installContext) {
        AnnotationConfigApplicationContext context = this.createDatabaseInitApplicationContext(installContext);
        context.register(new Class[]{HibernateJpaAutoConfiguration.class, PackageManagerRepositoryConfiguration.class, PackageManagerExecutionEngineConfiguration.class, PackageManagerFactoryConfiguration.class});
        return context;
    }

    protected AnnotationConfigApplicationContext createDatabaseInitApplicationContext(InstallContext installContext) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        beanFactory.registerSingleton(InstallContext.class.getCanonicalName(), (Object)installContext);
        context.register(new Class[]{InstallContextBasedConfiguration.class, DataSourceAutoConfiguration.class, LiquibaseAutoConfiguration.class, LiquibaseAutoConfiguration.LiquibaseConfiguration.class, DataSourceConfiguration.class});
        return context;
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_PREPAREDATABASEINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }

    @Configuration
    public static class InstallContextBasedConfiguration {
        @Autowired
        InstallContext installContext;

        @Bean
        @Scope(value="prototype")
        public ManagerHome managerHome() {
            return this.installContext.getManagerHome();
        }

        @Bean
        @Scope(value="prototype")
        public PackageManager packageManager() {
            return this.installContext.getPackageManager();
        }

        @Bean
        @Scope(value="singleton")
        public DownloadManager downloadManager(ManagerHome managerHome) {
            PackageManagerConfiguration configuration = (PackageManagerConfiguration)managerHome.getConfiguration(PackageManagerConfiguration.class);
            return DownloadManagerFactory.create((String)managerHome.getMetadata().getServerID(), (NetworkConfiguration.ProxyConfiguration)configuration.getProxyConfiguration());
        }
    }
}

