/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.ui.UI;
import java.util.function.Consumer;
import org.openthinclient.advisor.check.AbstractCheck;
import org.openthinclient.advisor.check.CheckExecutionEngine;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.openthinclient.advisor.check.CheckTask;
import org.openthinclient.wizard.FirstStartWizardMessages;

public class CheckingProgressPresenter {
    private final CheckExecutionEngine checkExecutionEngine;
    private final View view;
    private final Consumer<Result> resultConsumer;
    private CheckTask<?> task;
    private volatile CheckExecutionResult.CheckResultType currentResultType;
    protected IMessageConveyor mc;

    public CheckingProgressPresenter(CheckExecutionEngine checkExecutionEngine, View view, Consumer<Result> resultConsumer) {
        this.checkExecutionEngine = checkExecutionEngine;
        this.view = view;
        this.resultConsumer = resultConsumer;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        view.setOnOkHandler(this::handleOnOK);
        view.setOnCancelHandler(this::handleOnCancel);
    }

    private void handleOnCancel(View view) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.resultConsumer.accept(Result.CANCEL);
        view.close();
    }

    private void handleOnOK(View view) {
        if (this.currentResultType != null) {
            switch (this.currentResultType) {
                case WARNING: 
                case SUCCESS: {
                    this.resultConsumer.accept(Result.SUCCESS_OK);
                    break;
                }
                case FAILED: {
                    this.resultConsumer.accept(Result.ERROR);
                }
            }
            view.close();
        }
    }

    public void execute(AbstractCheck<?> check) {
        if (this.task != null) {
            throw new IllegalStateException("this presenter has already been executed. Re-execution is not supported.");
        }
        this.view.setInProgress();
        this.task = this.checkExecutionEngine.execute(check);
        this.task.onResult(result -> {
            this.currentResultType = result.getType();
            this.view.accessUI(view -> {
                switch (result.getType()) {
                    case FAILED: {
                        view.setError(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_CHECK_NETWORK_FAILED, new Object[0]));
                        break;
                    }
                    case WARNING: 
                    case SUCCESS: {
                        view.setSuccess(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_CHECK_NETWORK_SUCCEED, new Object[0]));
                    }
                }
            });
        });
    }

    public static interface View {
        public void accessUI(Consumer<View> var1);

        public void setInProgress();

        public void setSuccess(String var1);

        public void setError(String var1);

        public void setOnOkHandler(Consumer<View> var1);

        public void setOnCancelHandler(Consumer<View> var1);

        public void close();
    }

    public static enum Result {
        SUCCESS_OK,
        CANCEL,
        ERROR;

    }
}

