/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openthinclient.common.model.OrganizationalUnit;
import org.openthinclient.db.DatabaseConfiguration;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.DatabaseModel;
import org.openthinclient.wizard.model.DirectoryModel;
import org.openthinclient.wizard.model.NetworkConfigurationModel;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinstallInformationPanel
extends Panel {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SystemSetupModel systemSetupModel;
    private IMessageConveyor mc;

    public ReinstallInformationPanel(VerticalLayout root, SystemSetupModel systemSetupModel) {
        this.systemSetupModel = systemSetupModel;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setWidth(95.0f, Sizeable.Unit.PERCENTAGE);
        this.addStyleName("resume-panel");
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSpacing(true);
        Image logoImage = new Image();
        logoImage.setSource((Resource)new ThemeResource("img/OpenThinClient-logo.svg.png"));
        layout.addComponent((Component)logoImage);
        layout.setComponentAlignment((Component)logoImage, Alignment.MIDDLE_CENTER);
        Label title = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_TITLE, new Object[0]));
        title.setStyleName("huge");
        layout.addComponent((Component)title);
        Label text = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_TEXT, new Object[0]), ContentMode.HTML);
        text.setStyleName("large");
        layout.addComponent((Component)text);
        HorizontalLayout buttonLine = new HorizontalLayout();
        Button startInstallation = new Button(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_BUTTON_INSTALLATION, new Object[0]));
        startInstallation.setVisible(false);
        startInstallation.addClickListener((Button.ClickListener & Serializable)e -> {
            root.removeComponent((Component)this);
            this.exitPanel();
        });
        Button skipResumeButton = new Button(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_BUTTON_SKIP, new Object[0]));
        skipResumeButton.addClickListener((Button.ClickListener & Serializable)e -> {
            root.removeComponent((Component)this);
            this.exitPanel();
        });
        Button resumeButton = new Button(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_BUTTON_START, new Object[0]));
        resumeButton.addClickListener((Button.ClickListener & Serializable)e -> {
            List<String> list = this.restoreSavedProperties();
            Label result = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT, new Object[0]) + "<ul>" + list.stream().map(s -> "<li>" + s + "</li>").collect(Collectors.joining()) + "</ul>", ContentMode.HTML);
            result.setStyleName("large");
            layout.addComponent((Component)result, layout.getComponentIndex((Component)text) + 1);
            startInstallation.setVisible(true);
            resumeButton.setVisible(false);
            skipResumeButton.setVisible(false);
        });
        buttonLine.addComponents(new Component[]{skipResumeButton, resumeButton, startInstallation});
        layout.addComponent((Component)buttonLine);
        this.setContent((Component)layout);
    }

    public void exitPanel() {
    }

    private List<String> restoreSavedProperties() {
        ManagerHomeFactory managerHomeFactory = this.systemSetupModel.getFactory();
        ArrayList<String> resumeResult = new ArrayList<String>();
        if (InstallationDirectoryUtil.existsInstallationProgressFile((File)managerHomeFactory.getManagerHomeDirectory())) {
            ManagerHome managerHome;
            block15: {
                this.logger.info("Found existing installation file, try to read already setup properties.");
                managerHome = managerHomeFactory.create();
                try {
                    PackageManagerConfiguration packageManagerConfiguration = (PackageManagerConfiguration)managerHome.getConfiguration(PackageManagerConfiguration.class);
                    NetworkConfigurationModel networkConfigurationModel = this.systemSetupModel.getNetworkConfigurationModel();
                    if (packageManagerConfiguration.getProxyConfiguration() != null) {
                        this.logger.info("Restore previous setup proxy settings.");
                        networkConfigurationModel.getProxyConfiguration().setEnabled(true);
                        networkConfigurationModel.getProxyConfiguration().setPort(packageManagerConfiguration.getProxyConfiguration().getPort());
                        networkConfigurationModel.getProxyConfiguration().setHost(packageManagerConfiguration.getProxyConfiguration().getHost());
                        networkConfigurationModel.getProxyConfiguration().setUser(packageManagerConfiguration.getProxyConfiguration().getUser());
                        networkConfigurationModel.getProxyConfiguration().setPassword(packageManagerConfiguration.getProxyConfiguration().getPassword());
                        resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_PROXY_RESTORED, new Object[0]));
                    } else {
                        this.logger.info("No proxy settings found, using defaults.");
                        resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_PROXY_DEFAULT, new Object[0]));
                    }
                }
                catch (Exception e) {
                    this.logger.error("Cannot restore proxy settings", (Throwable)e);
                    resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_PROXY_FAIL, new Object[0]));
                }
                try {
                    DatabaseConfiguration databaseConfiguration = (DatabaseConfiguration)managerHome.getConfiguration(DatabaseConfiguration.class);
                    DatabaseModel databaseModel = this.systemSetupModel.getDatabaseModel();
                    if (databaseConfiguration != null && databaseConfiguration.getType() != null) {
                        databaseModel.setType(databaseConfiguration.getType());
                        if (databaseConfiguration.getType() == DatabaseConfiguration.DatabaseType.MYSQL) {
                            DatabaseModel.MySQLConfiguration mySQLConfiguration = databaseModel.getMySQLConfiguration();
                            String url = databaseConfiguration.getUrl();
                            try {
                                URI uri = new URI(url.substring(5));
                                mySQLConfiguration.setDatabase(uri.getPath().substring(1));
                                mySQLConfiguration.setHostname(uri.getHost());
                                mySQLConfiguration.setPort(uri.getPort());
                            }
                            catch (URISyntaxException e) {
                                this.logger.error("Cannot parse database uri, using defaults.");
                            }
                            mySQLConfiguration.setUsername(databaseConfiguration.getUsername());
                            mySQLConfiguration.setPassword(databaseConfiguration.getPassword());
                        }
                        resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DB_RESTORED, new Object[0]));
                        break block15;
                    }
                    this.logger.info("No database settings found, using defaults.");
                    resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DB_DEFAULT, new Object[0]));
                }
                catch (Exception e) {
                    this.logger.error("Cannot restore database settings", (Throwable)e);
                    resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DB_FAIL, new Object[0]));
                }
            }
            try {
                DirectoryServiceConfiguration directoryServiceConfiguration = (DirectoryServiceConfiguration)managerHome.getConfiguration(DirectoryServiceConfiguration.class);
                DirectoryModel directoryModel = this.systemSetupModel.getDirectoryModel();
                if (directoryServiceConfiguration != null) {
                    OrganizationalUnit primaryOU = directoryModel.getPrimaryOU();
                    primaryOU.setName(directoryServiceConfiguration.getPrimaryOU());
                    resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DIR_RESTORED, new Object[0]));
                } else {
                    this.logger.info("No directory settings found, using defaults.");
                    resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DB_DEFAULT, new Object[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("Cannot restore directory settings", (Throwable)e);
                resumeResult.add(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_RESUME_RESULT_DIR_FAIL, new Object[0]));
            }
        }
        return resumeResult;
    }
}

