/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.IntegerRangeValidator;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.openthinclient.db.DatabaseConfiguration;
import org.openthinclient.db.conf.DataSourceConfiguration;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.DatabaseModel;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.steps.AbstractStep;

public class ConfigureDatabaseStep
extends AbstractStep {
    private final SystemSetupModel systemSetupModel;
    private final CssLayout configFormContainer;
    private final MySQLConnectionConfigurationForm mySQLConnectionConfigurationForm;
    private final Label errorLabel;
    private NativeSelect<DatabaseConfiguration.DatabaseType> select;
    private Binder<DatabaseModel> databaseTypeBinder;

    public ConfigureDatabaseStep(SystemSetupModel systemSetupModel) {
        this.systemSetupModel = systemSetupModel;
        this.mySQLConnectionConfigurationForm = new MySQLConnectionConfigurationForm(systemSetupModel.getDatabaseModel().getMySQLConfiguration());
        VerticalLayout contents = new VerticalLayout();
        contents.setMargin(true);
        contents.setSpacing(true);
        contents.addComponent((Component)this.createLabelH1(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_HEADLINE, new Object[0])));
        contents.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_TEXT, new Object[0])));
        FormLayout mainForm = new FormLayout();
        this.select = new NativeSelect(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_TYPE, new Object[0]));
        this.select.setItems((Object[])DatabaseConfiguration.DatabaseType.values());
        this.select.setEmptySelectionAllowed(false);
        this.databaseTypeBinder = new Binder();
        this.databaseTypeBinder.setBean((Object)systemSetupModel.getDatabaseModel());
        this.databaseTypeBinder.forField(this.select).bind(DatabaseModel::getType, DatabaseModel::setType);
        this.databaseTypeBinder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            DatabaseConfiguration.DatabaseType type = (DatabaseConfiguration.DatabaseType)event.getValue();
            this.onDatabaseTypeChanged(type);
        });
        mainForm.addComponent(this.select);
        contents.addComponent((Component)mainForm);
        this.errorLabel = new Label();
        this.errorLabel.setStyleName("failure");
        this.errorLabel.setVisible(false);
        contents.addComponent((Component)this.errorLabel);
        this.configFormContainer = new CssLayout();
        contents.addComponent((Component)this.configFormContainer);
        this.onDatabaseTypeChanged(systemSetupModel.getDatabaseModel().getType());
        this.setContent((Component)contents);
    }

    private void onDatabaseTypeChanged(DatabaseConfiguration.DatabaseType type) {
        this.configFormContainer.removeAllComponents();
        if (type == DatabaseConfiguration.DatabaseType.MYSQL) {
            this.configFormContainer.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_INFO_MYSQL, new Object[0]), ContentMode.HTML));
            this.configFormContainer.addComponent((Component)this.mySQLConnectionConfigurationForm);
        } else if (type == DatabaseConfiguration.DatabaseType.APACHE_DERBY) {
            this.configFormContainer.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_INFO_DERBY, new Object[0]), ContentMode.HTML));
        } else {
            this.configFormContainer.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_INFO_H2, new Object[0]), ContentMode.HTML));
        }
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_TITLE, new Object[0]);
    }

    public boolean onAdvance() {
        this.setErrorMessage(null);
        this.databaseTypeBinder.writeBeanIfValid((Object)this.systemSetupModel.getDatabaseModel());
        switch (this.systemSetupModel.getDatabaseModel().getType()) {
            case APACHE_DERBY: {
                return true;
            }
            case MYSQL: {
                return this.validateMySQLConnection();
            }
            case H2: {
                return true;
            }
        }
        throw new IllegalStateException(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_EXECPTION_DB_TYPE_UNSUPPORTED, new Object[0]));
    }

    private boolean validateMySQLConnection() {
        this.mySQLConnectionConfigurationForm.writeBeanIfValid();
        DatabaseConfiguration configuration = new DatabaseConfiguration();
        configuration.setType(DatabaseConfiguration.DatabaseType.MYSQL);
        DatabaseModel.apply(this.systemSetupModel.getDatabaseModel(), configuration);
        DataSource source = DataSourceConfiguration.createDataSource((DatabaseConfiguration)configuration, (String)configuration.getUrl());
        try {
            DataSourceConfiguration.validateDataSource((javax.sql.DataSource)source);
        }
        catch (SQLException e) {
            this.setErrorMessage(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_EXECPTION_DB_CONNECTION_FAILED, new Object[0]));
            return false;
        }
        return true;
    }

    private void setErrorMessage(String message) {
        this.errorLabel.setValue(message);
        this.errorLabel.setVisible(message != null);
    }

    public boolean onBack() {
        return true;
    }

    protected static class MySQLConnectionConfigurationForm
    extends FormLayout {
        private Binder<DatabaseModel.MySQLConfiguration> mySQLConnectionConfigurationBinder;
        private DatabaseModel.MySQLConfiguration configuration;

        public MySQLConnectionConfigurationForm(DatabaseModel.MySQLConfiguration configuration) {
            MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
            this.configuration = configuration;
            this.mySQLConnectionConfigurationBinder = new Binder();
            this.mySQLConnectionConfigurationBinder.setBean((Object)this.configuration);
            TextField hostName = new TextField(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_HOSTNAME, new Object[0]), "hostname");
            this.mySQLConnectionConfigurationBinder.bind((HasValue)hostName, DatabaseModel.MySQLConfiguration::getHostname, DatabaseModel.MySQLConfiguration::setHostname);
            this.addComponent((Component)hostName);
            TextField portField = new TextField(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_PORT, new Object[0]), "3306");
            this.mySQLConnectionConfigurationBinder.forField((HasValue)portField).withConverter((Converter)new StringToIntegerConverter(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_PORT_INVALID, new Object[0])){

                protected NumberFormat getFormat(Locale locale) {
                    DecimalFormat format = new DecimalFormat();
                    format.setMaximumFractionDigits(0);
                    format.setDecimalSeparatorAlwaysShown(false);
                    format.setParseIntegerOnly(true);
                    format.setGroupingUsed(false);
                    return format;
                }
            }).withValidator((Validator)new IntegerRangeValidator(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_PORT_INVALID, new Object[0]), Integer.valueOf(1), Integer.valueOf(65535))).bind(DatabaseModel.MySQLConfiguration::getPort, DatabaseModel.MySQLConfiguration::setPort);
            this.addComponent((Component)portField);
            TextField databaseField = new TextField(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_SCHEMA, new Object[0]), "database");
            this.mySQLConnectionConfigurationBinder.bind((HasValue)databaseField, DatabaseModel.MySQLConfiguration::getDatabase, DatabaseModel.MySQLConfiguration::setDatabase);
            this.addComponent((Component)databaseField);
            TextField usernameField = new TextField(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_USER, new Object[0]), "username");
            this.mySQLConnectionConfigurationBinder.bind((HasValue)usernameField, DatabaseModel.MySQLConfiguration::getUsername, DatabaseModel.MySQLConfiguration::setUsername);
            this.addComponent((Component)usernameField);
            PasswordField passwordField = new PasswordField(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDATABASESTEP_LABEL_DB_PASSWD, new Object[0]), "password");
            this.mySQLConnectionConfigurationBinder.bind((HasValue)passwordField, DatabaseModel.MySQLConfiguration::getPassword, DatabaseModel.MySQLConfiguration::setPassword);
            this.addComponent((Component)passwordField);
        }

        public void writeBeanIfValid() {
            this.mySQLConnectionConfigurationBinder.writeBeanIfValid((Object)this.configuration);
        }
    }
}

