/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.util.Lookup;

public abstract class AWTBridge {
    public static AWTBridge getDefault() {
        AWTBridge aWTBridge = (AWTBridge)Lookup.getDefault().lookup(AWTBridge.class);
        return aWTBridge == null ? new Default() : aWTBridge;
    }

    public abstract JPopupMenu createEmptyPopup();

    public abstract JMenuItem createMenuPresenter(Action var1);

    public abstract JMenuItem createPopupPresenter(Action var1);

    public abstract Component createToolbarPresenter(Action var1);

    public abstract Component[] convertComponents(Component var1);

    private static final class Default
    extends AWTBridge {
        private Default() {
        }

        public JMenuItem createMenuPresenter(Action action) {
            return new JMenuItem(action);
        }

        public JMenuItem createPopupPresenter(Action action) {
            return new JMenuItem(action);
        }

        public Component createToolbarPresenter(Action action) {
            return new JButton(action);
        }

        public JPopupMenu createEmptyPopup() {
            return new JPopupMenu();
        }

        public Component[] convertComponents(Component component) {
            return new Component[]{component};
        }
    }
}

