/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class JXDatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private DateFormat[] _formats = null;

    public JXDatePickerFormatter() {
        this._formats = new DateFormat[3];
        this._formats[0] = new SimpleDateFormat(UIManager.getString("JXDatePicker.longFormat"));
        this._formats[1] = new SimpleDateFormat(UIManager.getString("JXDatePicker.mediumFormat"));
        this._formats[2] = new SimpleDateFormat(UIManager.getString("JXDatePicker.shortFormat"));
    }

    public JXDatePickerFormatter(DateFormat[] formats) {
        this._formats = formats;
    }

    public DateFormat[] getFormats() {
        return this._formats;
    }

    public Object stringToValue(String text) throws ParseException {
        Date result = null;
        ParseException pex = null;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < this._formats.length; ++i) {
            try {
                Date d = this._formats[i].parse(text);
                if (null != result && Math.abs(d.getTime() - System.currentTimeMillis()) >= Math.abs(result.getTime() - System.currentTimeMillis())) continue;
                result = d;
                continue;
            }
            catch (ParseException ex) {
                pex = ex;
            }
        }
        if (null == result && pex != null) {
            throw pex;
        }
        return result;
    }

    public String valueToString(Object value) throws ParseException {
        if (value != null) {
            return this._formats[0].format(value);
        }
        return null;
    }
}

