/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.jdesktop.swingx.ErrorReporter;
import org.jdesktop.swingx.IncidentInfo;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.util.WindowUtils;

public class JXErrorDialog
extends JDialog {
    private static String CLASS_NAME;
    private static Icon DEFAULT_ERROR_ICON;
    private static Icon DEFAULT_WARNING_ICON;
    private static ErrorReporter DEFAULT_REPORTER;
    private JEditorPane errorMessage;
    private JXEditorPane details;
    private EqualSizeJButton detailButton;
    private JXPanel detailsPanel;
    private JLabel iconLabel;
    private EqualSizeJButton reportButton;
    private IncidentInfo incidentInfo;
    private Action reportAction;
    private ErrorReporter reporter = DEFAULT_REPORTER;
    private Icon errorIcon = DEFAULT_ERROR_ICON;
    private Icon warningIcon = DEFAULT_WARNING_ICON;
    private int collapsedHeight = 0;
    private int expandedHeight = 0;

    public JXErrorDialog(Frame owner) {
        super(owner, true);
        this.initGui();
    }

    public JXErrorDialog(Dialog owner) {
        super(owner, true);
        this.initGui();
    }

    public void setIncidentInfo(IncidentInfo info) {
        IncidentInfo old = this.incidentInfo;
        this.incidentInfo = info;
        this.firePropertyChange("incidentInfo", old, this.incidentInfo);
        this.reinit();
    }

    public IncidentInfo getIncidentInfo() {
        return this.incidentInfo;
    }

    public void setErrorReporter(ErrorReporter rep) {
        ErrorReporter old = this.reporter;
        this.reporter = rep == null ? DEFAULT_REPORTER : rep;
        this.firePropertyChange("errorReporter", old, this.reporter);
        this.reinit();
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public void setErrorIcon(Icon icon) {
        Icon old = this.errorIcon;
        this.errorIcon = icon == null ? DEFAULT_ERROR_ICON : icon;
        this.firePropertyChange("errorIcon", old, this.errorIcon);
        this.reinit();
    }

    public Icon getErrorIcon() {
        return this.errorIcon;
    }

    public void setWarningIcon(Icon icon) {
        Icon old = this.warningIcon;
        this.warningIcon = icon == null ? DEFAULT_WARNING_ICON : icon;
        this.firePropertyChange("warningIcon", old, this.warningIcon);
        this.reinit();
    }

    public Icon getWarningIcon() {
        return this.warningIcon;
    }

    public void setReportAction(Action action) {
        Action old = this.reportAction;
        this.reportAction = action == null ? new ReportAction() : action;
        this.firePropertyChange("reportAction", old, this.reportAction);
        this.reportButton.setAction(this.reportAction);
    }

    public Action getReportAction() {
        return this.reportAction;
    }

    private void initGui() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(22, 12, 11, 17);
        this.iconLabel = new JLabel(DEFAULT_ERROR_ICON);
        this.getContentPane().add((Component)this.iconLabel, gbc);
        this.errorMessage = new JEditorPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setOpaque(false);
        this.errorMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0E-5;
        gbc.insets = new Insets(24, 0, 0, 11);
        this.getContentPane().add((Component)this.errorMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 22;
        gbc.insets = new Insets(12, 0, 11, 5);
        EqualSizeJButton okButton = new EqualSizeJButton(UIManager.getString(CLASS_NAME + ".ok_button_text"));
        this.getContentPane().add((Component)okButton, gbc);
        this.reportAction = new ReportAction();
        this.reportButton = new EqualSizeJButton(this.reportAction);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 0, 11, 5);
        this.getContentPane().add((Component)this.reportButton, gbc);
        this.reportButton.setVisible(false);
        this.detailButton = new EqualSizeJButton(UIManager.getString(CLASS_NAME + ".details_expand_text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 0, 11, 11);
        this.getContentPane().add((Component)this.detailButton, gbc);
        this.details = new JXEditorPane();
        this.details.setContentType("text/html");
        this.details.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.details.setTransferHandler(new DetailsTransferHandler());
        JScrollPane detailsScrollPane = new JScrollPane(this.details);
        detailsScrollPane.setPreferredSize(new Dimension(10, 250));
        this.details.setEditable(false);
        this.detailsPanel = new JXPanel(new GridBagLayout());
        this.detailsPanel.add((Component)detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 11, 11, 11), 0, 0));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.detailsPanel, gbc);
        JButton button = new JButton(UIManager.getString(CLASS_NAME + ".copy_to_clipboard_button_text"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JXErrorDialog.this.details.copy();
            }
        });
        gbc = new GridBagConstraints();
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 11, 11, 11);
        this.detailsPanel.add((Component)button, gbc);
        EqualSizeJButton[] buttons = new EqualSizeJButton[]{this.detailButton, okButton, this.reportButton};
        okButton.setGroup(buttons);
        this.reportButton.setGroup(buttons);
        this.detailButton.setGroup(buttons);
        okButton.setMinimumSize(okButton.getPreferredSize());
        this.reportButton.setMinimumSize(this.reportButton.getPreferredSize());
        this.detailButton.setMinimumSize(this.detailButton.getPreferredSize());
        okButton.addActionListener(new OkClickEvent());
        this.detailButton.addActionListener(new DetailsClickEvent());
    }

    private void setDetails(String details) {
        if (details == null || details.equals("")) {
            this.setDetailsVisible(false);
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(details);
            this.setDetailsVisible(false);
            this.detailButton.setVisible(true);
        }
    }

    private void setDetailsVisible(boolean b) {
        if (b) {
            this.collapsedHeight = this.getHeight();
            this.setSize(this.getWidth(), this.expandedHeight == 0 ? this.collapsedHeight + 300 : this.expandedHeight);
            this.detailsPanel.setVisible(true);
            this.detailButton.setText(UIManager.getString(CLASS_NAME + ".details_contract_text"));
            this.detailsPanel.applyComponentOrientation(this.detailButton.getComponentOrientation());
            this.details.setText(this.details.getText());
            this.details.setCaretPosition(0);
        } else {
            this.expandedHeight = this.getHeight();
            this.detailsPanel.setVisible(false);
            this.detailButton.setText(UIManager.getString(CLASS_NAME + ".details_expand_text"));
            this.errorMessage.setSize(0, 0);
            this.errorMessage.setSize(this.errorMessage.getPreferredSize());
            this.setSize(this.getWidth(), this.collapsedHeight);
        }
        this.repaint();
    }

    private void setErrorMessage(String errorMessage) {
        if (BasicHTML.isHTMLString(errorMessage)) {
            this.errorMessage.setContentType("text/html");
        } else {
            this.errorMessage.setContentType("text/plain");
        }
        this.errorMessage.setText(errorMessage);
    }

    private void reinit() {
        this.reportButton.setVisible(this.getErrorReporter() != null);
        if (this.incidentInfo == null) {
            this.iconLabel.setIcon(DEFAULT_ERROR_ICON);
            this.setTitle("");
            this.setErrorMessage("");
            this.setDetails("");
        } else {
            this.iconLabel.setIcon(this.incidentInfo.getErrorLevel() == Level.SEVERE ? this.errorIcon : this.warningIcon);
            this.setTitle(this.incidentInfo.getHeader());
            this.setErrorMessage(this.incidentInfo.getBasicErrorMessage());
            String details = this.incidentInfo.getDetailedErrorMessage();
            if (details == null) {
                if (this.incidentInfo.getErrorException() != null) {
                    StringBuffer html = new StringBuffer("<html>");
                    html.append("<h2>" + this.incidentInfo.getHeader() + "</h2>");
                    html.append("<HR size='1' noshade>");
                    html.append("<div></div>");
                    html.append("<b>Message:</b>");
                    html.append("<pre>");
                    html.append("    " + this.incidentInfo.getErrorException().toString());
                    html.append("</pre>");
                    html.append("<b>Level:</b>");
                    html.append("<pre>");
                    html.append("    " + this.incidentInfo.getErrorLevel());
                    html.append("</pre>");
                    html.append("<b>Stack Trace:</b>");
                    html.append("<pre>");
                    for (StackTraceElement el : this.incidentInfo.getErrorException().getStackTrace()) {
                        html.append("    " + el.toString() + "\n");
                    }
                    html.append("</pre></html>");
                    details = html.toString();
                } else {
                    details = "";
                }
            }
            this.setDetails(details);
        }
        Dimension prefSize = this.errorMessage.getPreferredSize();
        prefSize.width = Math.min(500, prefSize.width);
        prefSize.width = Math.max(300, prefSize.width);
        this.errorMessage.setSize(prefSize);
        prefSize.height = this.errorMessage.getPreferredSize().height;
        this.errorMessage.setPreferredSize(prefSize);
    }

    public static void showDialog(Component owner, String title, Throwable e) {
        IncidentInfo ii = new IncidentInfo(title, null, null, e);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, String title, String errorMessage, Throwable e) {
        IncidentInfo ii = new IncidentInfo(title, errorMessage, null, e);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, String title, String errorMessage, String details) {
        IncidentInfo ii = new IncidentInfo(title, errorMessage, details);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, String title, String errorMessage) {
        IncidentInfo ii = new IncidentInfo(title, errorMessage, null);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, IncidentInfo info) {
        Window window = WindowUtils.findWindow(owner);
        JXErrorDialog dlg = window instanceof Dialog ? new JXErrorDialog((Dialog)window) : new JXErrorDialog((Frame)window);
        dlg.setIncidentInfo(info);
        if (owner != null) {
            dlg.applyComponentOrientation(owner.getComponentOrientation());
        } else {
            dlg.applyComponentOrientation(window.getComponentOrientation());
        }
        dlg.setDefaultCloseOperation(2);
        dlg.pack();
        dlg.setLocationRelativeTo(owner);
        dlg.setVisible(true);
    }

    public static ErrorReporter getReporter() {
        return DEFAULT_REPORTER;
    }

    public static void setReporter(ErrorReporter rep) {
        DEFAULT_REPORTER = rep;
    }

    public static ErrorReporter getDefaultErrorReporter() {
        return DEFAULT_REPORTER;
    }

    public static void setDefaultErrorReporter(ErrorReporter rep) {
        DEFAULT_REPORTER = rep;
    }

    public static void setDefaultErrorIcon(Icon icon) {
        DEFAULT_ERROR_ICON = icon;
    }

    public static Icon getDefaultErrorIcon() {
        return DEFAULT_ERROR_ICON;
    }

    public static void setDefaultWarningIcon(Icon icon) {
        DEFAULT_WARNING_ICON = icon;
    }

    public static Icon getDefaultWarningIcon() {
        return DEFAULT_WARNING_ICON;
    }

    static {
        DEFAULT_ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
        DEFAULT_WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
        CLASS_NAME = JXErrorDialog.class.getCanonicalName();
        ResourceBundle res = ResourceBundle.getBundle("org.jdesktop.swingx.plaf.resources.ErrorDialog");
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String lookup = CLASS_NAME + "." + key;
            if (UIManager.getString(lookup) != null) continue;
            UIManager.put(lookup, res.getString(key));
        }
    }

    private final class DetailsTransferHandler
    extends TransferHandler {
        private DetailsTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            String text = JXErrorDialog.this.details.getSelectedText();
            if (text == null || text.equals("")) {
                JXErrorDialog.this.details.selectAll();
                text = JXErrorDialog.this.details.getSelectedText();
                JXErrorDialog.this.details.select(-1, -1);
            }
            return new StringSelection(text);
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private static class EqualSizeJButton
    extends JButton {
        private EqualSizeJButton[] group;

        public EqualSizeJButton() {
        }

        public EqualSizeJButton(String text) {
            super(text);
        }

        public EqualSizeJButton(Action a) {
            super(a);
        }

        public void setGroup(EqualSizeJButton[] group) {
            this.group = group;
        }

        private Dimension getRealPreferredSize() {
            return super.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int width = 0;
            int height = 0;
            for (int iter = 0; iter < this.group.length; ++iter) {
                Dimension size = this.group[iter].getRealPreferredSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            return new Dimension(width, height);
        }
    }

    public class ReportAction
    extends AbstractAction {
        public boolean isEnabled() {
            return JXErrorDialog.this.getErrorReporter() != null;
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.this.getErrorReporter().reportIncident(JXErrorDialog.this.getIncidentInfo());
        }

        public Object getValue(String key) {
            if (key == "Name") {
                if (JXErrorDialog.this.getErrorReporter() != null && JXErrorDialog.this.getErrorReporter().getActionName() != null) {
                    return JXErrorDialog.this.getErrorReporter().getActionName();
                }
                return UIManager.getString(CLASS_NAME + ".report_button_text");
            }
            return super.getValue(key);
        }
    }

    private final class DetailsClickEvent
    implements ActionListener {
        private DetailsClickEvent() {
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.this.setDetailsVisible(!JXErrorDialog.this.detailsPanel.isVisible());
        }
    }

    private final class OkClickEvent
    implements ActionListener {
        private OkClickEvent() {
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.this.setVisible(false);
            JXErrorDialog.this.dispose();
        }
    }
}

