/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.MouseMessagingHandler;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.ProgressSource;

public class JXRootPane
extends JRootPane {
    private JXStatusBar statusBar;
    private JToolBar toolBar;
    private JPanel contentPanel = new JPanel();
    private JButton cancelButton;
    private MouseMessagingHandler handler;

    public JXRootPane() {
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        AbstractAction escAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JButton cancelButton = JXRootPane.this.getCancelButton();
                if (cancelButton != null) {
                    cancelButton.doClick(20);
                }
            }
        };
        this.getActionMap().put("esc-action", escAction);
        InputMap im = this.getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        im.put(key, "esc-action");
    }

    public void addComponent(Component comp) {
        this.contentPanel.add(comp);
        this.registerStatusBar(comp);
    }

    public void removeComponent(Component comp) {
        this.contentPanel.remove(comp);
        this.unregisterStatusBar(this.statusBar, comp);
    }

    public Component[] getContentComponents() {
        return this.contentPanel.getComponents();
    }

    private void registerStatusBar(Component comp) {
        Object source;
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof MessageSource) {
            source = (MessageSource)((Object)comp);
        }
        if (comp instanceof ProgressSource) {
            source = (ProgressSource)((Object)comp);
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.registerStatusBar(comps[i]);
            }
        }
    }

    private void unregisterStatusBar(JXStatusBar statusBar, Component comp) {
        Object source;
        if (statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof MessageSource) {
            source = (MessageSource)((Object)comp);
        }
        if (comp instanceof ProgressSource) {
            source = (ProgressSource)((Object)comp);
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.unregisterStatusBar(statusBar, comps[i]);
            }
        }
    }

    public void setStatusBar(JXStatusBar statusBar) {
        JXStatusBar oldStatusBar = this.statusBar;
        this.statusBar = statusBar;
        if (statusBar != null && this.handler == null) {
            if (this.toolBar != null) {
                // empty if block
            }
            if (this.menuBar != null) {
                // empty if block
            }
        }
        Component[] comps = this.contentPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            this.unregisterStatusBar(oldStatusBar, comps[i]);
            this.registerStatusBar(comps[i]);
        }
        if (oldStatusBar != null) {
            this.getContentPane().remove(oldStatusBar);
        }
        if (statusBar != null) {
            this.getContentPane().add("South", statusBar);
        }
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar toolBar) {
        JToolBar oldToolBar = this.toolBar;
        this.toolBar = toolBar;
        if (this.handler != null && oldToolBar != null) {
            this.handler.unregisterListeners(oldToolBar.getComponents());
        }
        if (this.handler != null && toolBar != null) {
            this.handler.registerListeners(toolBar.getComponents());
        }
        this.getContentPane().add("North", toolBar);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setJMenuBar(JMenuBar menuBar) {
        JMenuBar oldMenuBar = this.menuBar;
        super.setJMenuBar(menuBar);
        if (this.handler != null && oldMenuBar != null) {
            this.handler.unregisterListeners(oldMenuBar.getSubElements());
        }
        if (this.handler != null && menuBar != null) {
            this.handler.registerListeners(menuBar.getSubElements());
        }
    }

    public void setCancelButton(JButton cancelButton) {
        JButton old = this.cancelButton;
        if (old != cancelButton) {
            this.cancelButton = cancelButton;
            if (old != null) {
                old.repaint();
            }
            if (cancelButton != null) {
                cancelButton.repaint();
            }
        }
        this.firePropertyChange("cancelButton", old, cancelButton);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

