/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.gradient.BasicGradientPainter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;

public class BasicHeaderUI
extends HeaderUI {
    protected JLabel titleLabel;
    protected JXEditorPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;
    private LayoutManager layout;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.installDefaults(header);
        this.titleLabel = new JLabel("Title For Header Goes Here");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.descriptionPane = new JXEditorPane();
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText("The description for the header goes here.\nExample: Click the Copy Code button to generate the corresponding Java code.");
        this.imagePanel = new JLabel();
        this.imagePanel.setIcon(UIManager.getIcon("Header.defaultIcon"));
        this.installComponents(header);
        this.installListeners(header);
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.uninstallDefaults(header);
        this.uninstallListeners(header);
        this.uninstallComponents(header);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
        this.layout = null;
    }

    protected void installDefaults(JXHeader h) {
        Painter p = h.getBackgroundPainter();
        if (p == null || p instanceof PainterUIResource) {
            h.setBackgroundPainter(this.createBackgroundPainter());
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installListeners(final JXHeader h) {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(h, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        h.addPropertyChangeListener(this.propListener);
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName) || propertyName == null) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName) || propertyName == null) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName) || propertyName == null) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName) || propertyName == null) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        }
    }

    protected void installComponents(JXHeader h) {
        h.setLayout(new GridBagLayout());
        h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
        h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 24, 0, 11), 0, 0));
        h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
    }

    protected void uninstallComponents(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
    }

    protected Painter createBackgroundPainter() {
        return new PainterUIResource(new BasicGradientPainter(0.0f, 0.0f, Color.WHITE, 1.0f, 0.0f, UIManager.getColor("control")));
    }

    public void paint(Graphics g, JComponent c) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.add(this.titleLabel);
        panel.add(this.descriptionPane);
        panel.add(this.imagePanel);
        panel.setSize(c.getSize());
        this.layout.layoutContainer(panel);
        panel.paint(g);
    }
}

