/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.util.NbBundle;

public class CLIOptions
extends CLIHandler {
    static final String DIR_MODULES = "modules";
    protected static boolean noLogging = false;
    protected static boolean noSplash = false;
    protected static TopLogging logger;
    protected static Class uiClass;
    protected static int uiFontSize;
    private static String homeDir;
    private static String userDir;
    private static String systemDir;
    private static boolean specifiedBranding;

    public CLIOptions() {
        super(1);
    }

    protected int cli(CLIHandler.Args arguments) {
        return this.cli(arguments.getArguments());
    }

    public static boolean isGui() {
        return "true".equals(System.getProperty("org.openide.TopManager.GUI"));
    }

    private static boolean isOption(String value, String optionName) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("--")) {
            return value.substring(2).equals(optionName);
        }
        if (value.startsWith("-")) {
            return value.substring(1).equals(optionName);
        }
        return false;
    }

    public final int cli(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            boolean used = true;
            if (CLIOptions.isOption(args[i], "nogui")) {
                System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
                System.setProperty("org.openide.TopManager.GUI", "false");
            } else if (CLIOptions.isOption(args[i], "nosplash")) {
                noSplash = true;
            } else if (!CLIOptions.isOption(args[i], "noinfo")) {
                if (CLIOptions.isOption(args[i], "nologging")) {
                    noLogging = true;
                } else {
                    if (CLIOptions.isOption(args[i], "userdir")) {
                        args[i] = null;
                        try {
                            System.setProperty("netbeans.user", args[++i]);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                            return 2;
                        }
                    }
                    if (CLIOptions.isOption(args[i], "ui") || CLIOptions.isOption(args[i], "laf")) {
                        args[i] = null;
                        try {
                            String ui = args[++i];
                            if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(ui) && System.getProperty("java.version").indexOf("1.4.2") != -1) {
                                System.err.println(CLIOptions.getString("MSG_GTKNotSupported"));
                            }
                            uiClass = Class.forName(ui);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println(CLIOptions.getString("ERR_UIExpected"));
                            return 2;
                        }
                        catch (ClassNotFoundException e2) {
                            System.err.println(CLIOptions.getString("ERR_UINotFound"));
                        }
                    } else {
                        if (CLIOptions.isOption(args[i], "fontsize")) {
                            args[i] = null;
                            try {
                                uiFontSize = Integer.parseInt(args[++i]);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                System.err.println(CLIOptions.getString("ERR_FontSizeExpected"));
                                return 2;
                            }
                            catch (NumberFormatException e2) {
                                System.err.println(CLIOptions.getString("ERR_BadFontSize"));
                                return 1;
                            }
                        }
                        if (CLIOptions.isOption(args[i], "locale")) {
                            String language;
                            args[i] = null;
                            String localeParam = args[++i];
                            String country = "";
                            String variant = "";
                            int index1 = localeParam.indexOf(":");
                            if (index1 == -1) {
                                language = localeParam;
                            } else {
                                language = localeParam.substring(0, index1);
                                int index2 = localeParam.indexOf(":", index1 + 1);
                                if (index2 != -1) {
                                    country = localeParam.substring(index1 + 1, index2);
                                    variant = localeParam.substring(index2 + 1);
                                } else {
                                    country = localeParam.substring(index1 + 1);
                                }
                            }
                            Locale.setDefault(new Locale(language, country, variant));
                        } else if (CLIOptions.isOption(args[i], "branding")) {
                            args[i] = null;
                            if (++i == args.length) {
                                System.err.println(CLIOptions.getString("ERR_BrandingNeedsArgument"));
                                return 2;
                            }
                            String branding = args[i];
                            if (branding.equals("-")) {
                                branding = null;
                            }
                            try {
                                NbBundle.setBranding((String)branding);
                            }
                            catch (IllegalArgumentException iae) {
                                iae.printStackTrace();
                                return 1;
                            }
                            specifiedBranding = true;
                        } else {
                            used = false;
                        }
                    }
                }
            }
            if (!used) continue;
            args[i] = null;
        }
        return 0;
    }

    public static void initialize() {
        if (!noLogging) {
            try {
                logger = "memory".equals(CLIOptions.getUserDir()) ? new TopLogging(null) : new TopLogging(CLIOptions.getLogDir());
            }
            catch (IOException e) {
                System.err.println("Cannot create log file. Logging disabled.");
                e.printStackTrace();
            }
        }
        StartLog.logProgress("TopLogging initialized");
    }

    protected void usage(PrintWriter w) {
        w.println("Core options:");
        w.println("  --laf <LaF classname> use given LookAndFeel class instead of the default");
        w.println("  --fontsize <size>     set the base font size of the user interface, in points");
        w.println("  --locale <language[:country[:variant]]> use specified locale");
        w.println("  --userdir <path>      use specified directory to store user settings");
        w.println("");
    }

    private static String getString(String key) {
        return NbBundle.getMessage(CLIOptions.class, (String)key);
    }

    public static String getLogDir() {
        return new File(new File(CLIOptions.getUserDir(), "var"), "log").toString();
    }

    static final void clearForTests() {
        homeDir = null;
        userDir = null;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.home");
        }
        return homeDir;
    }

    public static String getUserDir() {
        if (userDir == null) {
            userDir = System.getProperty("netbeans.user");
            if ("memory".equals(userDir)) {
                return "memory";
            }
            if (userDir == null) {
                System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"ERR_no_user_directory"));
                Thread.dumpStack();
                TopSecurityManager.exit((int)1);
            }
            if (userDir.equals(CLIOptions.getHomeDir())) {
                System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"ERR_user_directory_is_home"));
                TopSecurityManager.exit((int)1);
            }
            File f = new File(userDir);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            userDir = f.getPath();
            System.setProperty("netbeans.user", userDir);
            File systemDirFile = new File(userDir, "config");
            CLIOptions.makedir(systemDirFile);
            systemDir = systemDirFile.getAbsolutePath();
            CLIOptions.makedir(new File(userDir, DIR_MODULES));
        }
        return userDir;
    }

    private static void makedir(File f) {
        Object[] arg;
        if (f.isFile()) {
            arg = new Object[]{f};
            System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"CTL_CannotCreate_text", (Object[])arg));
            TopSecurityManager.exit((int)6);
        }
        if (!f.exists() && !f.mkdirs()) {
            arg = new Object[]{f};
            System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"CTL_CannotCreateSysDir_text", (Object[])arg));
            TopSecurityManager.exit((int)7);
        }
    }

    protected static String getSystemDir() {
        CLIOptions.getUserDir();
        return systemDir;
    }

    public static int getFontSize() {
        return uiFontSize;
    }

    static {
        uiFontSize = 0;
        specifiedBranding = false;
    }
}

