/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private static final File[] dirs;
    private static Map fileCache;

    private static void addDir(List _dirs, String d) {
        File f;
        if (d != null && (f = new File(d).getAbsoluteFile()).isDirectory()) {
            _dirs.add(f);
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap();
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        fileCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File locate(String relativePath, String codeNameBase, boolean localized) {
        String name;
        String prefix;
        if (relativePath.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (relativePath.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + relativePath);
        }
        int slashIdx = relativePath.lastIndexOf(47);
        if (slashIdx == relativePath.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + relativePath);
        }
        if (slashIdx != -1) {
            prefix = relativePath.substring(0, slashIdx + 1);
            name = relativePath.substring(slashIdx + 1);
            assert (name.length() > 0);
        } else {
            prefix = "";
            name = relativePath;
        }
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (localized) {
                String ext;
                String baseName;
                int i = name.lastIndexOf(46);
                if (i == -1) {
                    baseName = name;
                    ext = "";
                } else {
                    baseName = name.substring(0, i);
                    ext = name.substring(i);
                }
                String[] suffixes = Util.getLocalizingSuffixesFast();
                for (int j = 0; j < suffixes.length; ++j) {
                    String locName = baseName + suffixes[j] + ext;
                    File f = InstalledFileLocatorImpl.locateExactPath(prefix, locName);
                    if (f == null) continue;
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return f;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return InstalledFileLocatorImpl.locateExactPath(prefix, name);
        }
    }

    private static File locateExactPath(String prefix, String name) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        if (fileCache != null) {
            int i;
            HashMap<File, HashSet<String>> fileCachePerPrefix = (HashMap<File, HashSet<String>>)fileCache.get(prefix);
            if (fileCachePerPrefix == null) {
                fileCachePerPrefix = new HashMap<File, HashSet<String>>(dirs.length * 2);
                for (i = 0; i < dirs.length; ++i) {
                    File d;
                    File root = dirs[i];
                    if (prefix.length() > 0) {
                        assert (prefix.charAt(prefix.length() - 1) == '/');
                        d = new File(root, prefix.substring(0, prefix.length() - 1).replace('/', File.separatorChar));
                    } else {
                        d = root;
                    }
                    if (!d.isDirectory()) continue;
                    String[] kids = d.list();
                    if (kids != null) {
                        fileCachePerPrefix.put(root, new HashSet<String>(Arrays.asList(kids)));
                        continue;
                    }
                    ErrorManager.getDefault().log(16, "Warning - could not read files in " + d);
                }
                fileCache.put(prefix, fileCachePerPrefix);
            }
            for (i = 0; i < dirs.length; ++i) {
                Set names = (Set)fileCachePerPrefix.get(dirs[i]);
                if (names == null || !names.contains(name)) continue;
                return InstalledFileLocatorImpl.makeFile(dirs[i], prefix, name);
            }
        } else {
            for (int i = 0; i < dirs.length; ++i) {
                File f = InstalledFileLocatorImpl.makeFile(dirs[i], prefix, name);
                if (!f.exists()) continue;
                return f;
            }
        }
        return null;
    }

    private static File makeFile(File dir, String prefix, String name) {
        return FileUtil.normalizeFile((File)new File(dir, prefix.replace('/', File.separatorChar) + name));
    }

    static {
        ArrayList _dirs = new ArrayList();
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.user"));
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(_dirs, tok.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.home"));
        dirs = _dirs.toArray(new File[_dirs.size()]);
        fileCache = null;
    }
}

