/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.beans.Introspector;
import java.beans.PropertyEditorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.NbURLStreamHandlerFactory;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopThreadGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class Main {
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;
    private static Splash.SplashOutput splash;
    private static final boolean noBar;
    private static boolean nbFactoryInitialized;
    private static boolean editorsRegistered;

    public static void setSplashMaxSteps(int maxSteps) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.setMaxSteps(maxSteps);
    }

    public static void addToSplashMaxSteps(int steps) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.addToMaxSteps(steps);
    }

    public static void addAndSetSplashMaxSteps(int steps) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.addAndSetMaxSteps(steps);
    }

    public static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar(1);
    }

    public static void incrementSplashProgressBar(int steps) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.increment(steps);
    }

    public static void setStatusText(String msg) {
        if (splash != null) {
            splash.print(msg);
        }
        if (moduleSystemInitialized) {
            CoreBridge.conditionallyPrintStatus(msg);
        }
    }

    public static void main(String[] argv) throws Exception {
        TopThreadGroup tg = new TopThreadGroup("IDE Main", argv);
        StartLog.logStart("Forwarding to topThreadGroup");
        tg.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        if (!nbFactoryInitialized) {
            NbURLStreamHandlerFactory fact = new NbURLStreamHandlerFactory();
            try {
                URL.setURLStreamHandlerFactory(fact);
            }
            catch (Error e) {
                e.printStackTrace();
            }
            nbFactoryInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initUICustomizations() {
        block15: {
            if (!CLIOptions.isGui()) {
                return;
            }
            URL themeURL = null;
            boolean wantTheme = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
            try {
                if (wantTheme) {
                    FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("themes.xml");
                    if (fo == null) {
                        themeURL = Main.class.getResource("resources/themes.xml");
                    } else {
                        try {
                            themeURL = fo.getURL();
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            // empty catch block
                        }
                    }
                }
                if (CLIOptions.uiFontSize != 0) break block15;
                String key = "";
                try {
                    key = NbBundle.getMessage(Main.class, (String)"CTL_globalFontSize");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (key.length() > 0) {
                    try {
                        CLIOptions.uiFontSize = Integer.parseInt(key);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            finally {
                CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.uiFontSize, themeURL);
            }
        }
        if (CLIOptions.uiFontSize > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            ErrorManager.getDefault().log(16, NbBundle.getMessage(Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (moduleSystem != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return moduleSystem;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem(Repository.getDefault().getDefaultFileSystem());
            }
            catch (IOException ioe) {
                IllegalStateException ise = new IllegalStateException("Module system cannot be created");
                ErrorManager.getDefault().annotate((Throwable)ise, (Throwable)ioe);
                throw ise;
            }
            StartLog.logProgress("ModuleSystem created");
            // ** MonitorExit[var0] (shouldn't be in output)
            moduleSystem.loadBootModules();
            moduleSystem.readList();
            Main.addAndSetSplashMaxSteps(30);
            moduleSystem.restore();
            StartLog.logEnd("Modules initialization");
            moduleSystemInitialized = true;
            return moduleSystem;
        }
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] args) throws SecurityException {
        String jdkHome;
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0) {
            System.err.println("The IDE requires JDK 1.4 or higher to run.");
            TopSecurityManager.exit((int)1);
        }
        if ((jdkHome = System.getProperty("jdk.home")) == null) {
            jdkHome = System.getProperty("java.home");
            if (Utilities.getOperatingSystem() != 4096) {
                jdkHome = jdkHome + File.separator + "..";
            }
            System.setProperty("jdk.home", jdkHome);
        }
        try {
            Main.readEnvMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.initializeURLFactory();
        if (System.getProperties().get("org.openide.TopManager") == null) {
            System.setProperty("org.openide.TopManager.GUI", "true");
            System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
        }
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        StartLog.logStart("XML Factories");
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError exc) {
                String s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails1", (Object)exc.getMessage());
                System.out.println(s);
                s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(s);
                throw exc;
            }
        }
        StartLog.logEnd("XML Factories");
        InstalledFileLocatorImpl.prepareCache();
        String[] sysbisp = Introspector.getBeanInfoSearchPath();
        String[] nbbisp = new String[]{"org.netbeans.beaninfo"};
        String[] allbisp = new String[sysbisp.length + nbbisp.length];
        System.arraycopy(nbbisp, 0, allbisp, 0, nbbisp.length);
        System.arraycopy(sysbisp, 0, allbisp, nbbisp.length, sysbisp.length);
        Introspector.setBeanInfoSearchPath(allbisp);
        assert (Repository.getDefault() instanceof NbRepository) : "Has to be NbRepository: " + Repository.getDefault();
        StartLog.logProgress("Repository initialized");
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null && !Main.handleLicenseCheck()) {
                TopSecurityManager.exit((int)0);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        StartLog.logProgress("License check performed");
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null && !Main.handleImportOfUserDir()) {
                TopSecurityManager.exit((int)0);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        StartLog.logProgress("Upgrade wizard consulted");
        Main.showSplash();
        Main.setStatusText(NbBundle.getMessage(Main.class, (String)"MSG_IDEInit"));
        Main.getModuleSystem();
        Main.registerPropertyEditors();
        SharedClassObject.findObject((Class)Main.getKlass("org.netbeans.core.IDESettings"), (boolean)true);
        StartLog.logProgress("IDE settings loaded");
        for (RunLevel level : Lookup.getDefault().lookup(new Lookup.Template(RunLevel.class)).allInstances()) {
            level.run();
        }
        if (splash != null) {
            Splash.hideSplash(splash);
            splash = null;
        }
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
    }

    static final Splash.SplashOutput getSplash() {
        return splash;
    }

    protected static void showSplash() {
        if (!CLIOptions.noSplash) {
            if (splash != null) {
                if (Splash.isVisible(splash)) {
                    return;
                }
                splash = null;
            }
            splash = Splash.showSplash();
        }
    }

    public static final void registerPropertyEditors() {
        if (editorsRegistered) {
            return;
        }
        String[] syspesp = PropertyEditorManager.getEditorSearchPath();
        String[] nbpesp = new String[]{"org.netbeans.beaninfo.editors", "org.openide.explorer.propertysheet.editors"};
        String[] allpesp = new String[syspesp.length + nbpesp.length];
        System.arraycopy(nbpesp, 0, allpesp, 0, nbpesp.length);
        System.arraycopy(syspesp, 0, allpesp, nbpesp.length, syspesp.length);
        PropertyEditorManager.setEditorSearchPath(allpesp);
        PropertyEditorManager.registerEditor(Character.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.CharEditor"));
        PropertyEditorManager.registerEditor(Main.getKlass("[Ljava.lang.String;"), Main.getKlass("org.netbeans.beaninfo.editors.StringArrayEditor"));
        PropertyEditorManager.registerEditor(Main.getKlass("[Lorg.openide.loaders.DataObject;"), Main.getKlass("org.netbeans.beaninfo.editors.DataObjectArrayEditor"));
        PropertyEditorManager.registerEditor(Integer.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.IntEditor"));
        PropertyEditorManager.registerEditor(Boolean.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.BoolEditor"));
        StartLog.logProgress("PropertyEditors registered");
        editorsRegistered = true;
    }

    static final Class getKlass(String cls) {
        try {
            ModuleSystem ms = moduleSystem;
            ClassLoader loader = ms != null ? ms.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(cls, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    private static void putSystemProperty(String propName, String value, String failbackValue) {
        if (System.getProperty(propName) == null) {
            if (value != null) {
                System.setProperty(propName, value);
            } else {
                if (!Boolean.getBoolean("netbeans.suppress.sysprop.warning")) {
                    System.err.println("Warning: Versioning property \"" + propName + "\" is not set. Defaulting to \"" + failbackValue + '\"');
                    System.err.println("(to suppress this message run with -Dnetbeans.suppress.sysprop.warning=true)");
                }
                System.setProperty(propName, failbackValue);
            }
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private final File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            @Override
            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method showMethod = clazz.getMethod("main", String[].class);
                    showMethod.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (LinkageError e) {
                    e.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return true;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler handler = new ImportHandler();
        return handler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                File f = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
                if (f != null) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            @Override
            public void run() {
                Class clazz = Main.getKlass(this.classname);
                try {
                    Method showMethod = clazz.getMethod("showLicensePanel", null);
                    showMethod.invoke(null, null);
                    this.executedOk = true;
                    File f = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                    if (!f.exists()) {
                        f.getParentFile().mkdirs();
                        try {
                            f.createNewFile();
                        }
                        catch (IOException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = false;
                    } else {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (LinkageError ex) {
                    ex.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        LicenseHandler handler = new LicenseHandler();
        return handler.canContinue();
    }

    private static void readEnvMap() throws IOException {
        Properties env = System.getProperties();
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.5")) >= 0) {
            try {
                Method getenv = System.class.getMethod("getenv", null);
                Map m = (Map)getenv.invoke(null, null);
                for (Map.Entry entry : m.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    env.put("Env-".concat(key), value);
                    env.put("env-".concat(key.toLowerCase(Locale.US)), value);
                }
                return;
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        String envfile = System.getProperty("netbeans.osenv");
        if (envfile != null) {
            int c;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(envfile)));
            char sep = Boolean.getBoolean("netbeans.osenv.nullsep") ? (char)'\u0000' : '\n';
            StringBuffer key = new StringBuffer(100);
            StringBuffer value = new StringBuffer(1000);
            boolean inkey = true;
            while ((c = in.read()) != -1) {
                char cc = (char)c;
                if (inkey) {
                    if (cc == sep) {
                        throw new IOException("Environment variable name starting with '" + key + "' contained the separator (char)" + sep);
                    }
                    if (cc == '=') {
                        inkey = false;
                        continue;
                    }
                    key.append(cc);
                    continue;
                }
                if (cc == sep) {
                    inkey = true;
                    String k = key.toString();
                    String v = new String(value.toString());
                    env.put(new String("Env-" + k), v);
                    env.put(new String("env-" + k.toLowerCase(Locale.US)), v);
                    key.setLength(0);
                    value.setLength(0);
                    continue;
                }
                value.append(cc);
            }
        }
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar");
        editorsRegistered = false;
    }
}

