/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.core.startup.layers.PatchedURLStreamHandlerFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

final class NbURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static final boolean J2SE_141 = System.getProperty("java.version").startsWith("1.4.1");
    private Lookup.Result r = null;
    private URLStreamHandlerFactory[] handlers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandlerFactory[] _handlers;
        if (protocol.equals("jar") || protocol.equals("file") || protocol.equals("http") || protocol.equals("resource")) {
            URLStreamHandler handler = null;
            if (J2SE_141) {
                handler = PatchedURLStreamHandlerFactory.getInstance().createURLStreamHandler(protocol);
            }
            return handler;
        }
        if (protocol.equals("nbfs")) {
            return FileUtil.nbfsURLStreamHandler();
        }
        if (protocol.equals("nbres") || protocol.equals("nbresloc")) {
            return new NbResourceStreamHandler();
        }
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            if (this.r == null) {
                this.r = Lookup.getDefault().lookup(new Lookup.Template(URLStreamHandlerFactory.class));
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            _handlers = this.handlers;
        }
        for (int i = 0; i < _handlers.length; ++i) {
            URLStreamHandler h = _handlers[i].createURLStreamHandler(protocol);
            if (h == null) continue;
            return h;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        Collection c = this.r.allInstances();
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            this.handlers = c.toArray(new URLStreamHandlerFactory[0]);
        }
    }

    private static final class NbResourceStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
        public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

        @Override
        public URLConnection openConnection(URL u) throws IOException {
            if (u.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
                return new Connection(u, false);
            }
            if (u.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
                return new Connection(u, true);
            }
            throw new IOException("Bad protocol: " + u.getProtocol());
        }

        private static class Connection
        extends URLConnection {
            private final boolean localized;
            private URLConnection real;
            private IOException exception = null;

            public Connection(URL u, boolean localized) {
                super(u);
                this.localized = localized;
            }

            @Override
            public synchronized void connect() throws IOException {
                if (this.exception != null) {
                    IOException e = this.exception;
                    this.exception = null;
                    throw e;
                }
                if (!this.connected) {
                    URL target;
                    String resource = this.url.getFile();
                    if (resource.length() > 0 && resource.charAt(0) == '/') {
                        resource = resource.substring(1);
                    }
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (this.localized) {
                        String ext;
                        String base;
                        int dotIndex = resource.lastIndexOf(46);
                        if (dotIndex < resource.lastIndexOf(47)) {
                            dotIndex = -1;
                        }
                        if (dotIndex != -1) {
                            base = resource.substring(0, dotIndex);
                            ext = resource.substring(dotIndex);
                        } else {
                            base = resource;
                            ext = "";
                        }
                        target = null;
                        Iterator suffixes = NbBundle.getLocalizingSuffixes();
                        while (suffixes.hasNext()) {
                            String suffix = (String)suffixes.next();
                            target = loader.getResource(base + suffix + ext);
                            if (target == null) continue;
                            break;
                        }
                    } else {
                        target = loader.getResource(resource);
                    }
                    if (target == null) {
                        throw new IOException(NbBundle.getMessage(NbURLStreamHandlerFactory.class, (String)"EXC_nbres_cannot_connect", (Object)this.url));
                    }
                    this.real = target.openConnection();
                    this.real.connect();
                    this.connected = true;
                }
            }

            private void tryToConnect() {
                if (this.connected || this.exception != null) {
                    return;
                }
                try {
                    this.connect();
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }

            @Override
            public String getHeaderField(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(n);
                }
                return null;
            }

            @Override
            public String getHeaderFieldKey(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderFieldKey(n);
                }
                return null;
            }

            @Override
            public String getHeaderField(String key) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(key);
                }
                return null;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.real.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.real.getOutputStream();
            }

            @Override
            public String getContentType() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentType();
                }
                return "application/octet-stream";
            }

            @Override
            public int getContentLength() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentLength();
                }
                return 0;
            }
        }
    }
}

