/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Stack;

public class StartLog {
    private static final StartImpl impl;
    private static final Stack actions;
    private static final Stack places;
    private static final boolean DEBUG_NESTING;
    private static final String logProp;
    private static final String logFileProp;

    public static void logStart(String action) {
        if (StartLog.willLog()) {
            impl.start(action, System.currentTimeMillis());
            actions.push(action);
            if (DEBUG_NESTING) {
                places.push(new Throwable("logStart called here:"));
            }
        }
    }

    public static void logProgress(String note) {
        if (StartLog.willLog()) {
            impl.progress(note, System.currentTimeMillis());
        }
    }

    public static void logEnd(String action) {
        if (StartLog.willLog()) {
            Throwable oldplace;
            String old = actions.empty() ? null : (String)actions.pop();
            Throwable throwable = oldplace = DEBUG_NESTING && !places.empty() ? (Throwable)places.pop() : null;
            if (!action.equals(old)) {
                if (oldplace != null) {
                    oldplace.printStackTrace();
                } else {
                    System.err.println("Either ending too soon, or no info about caller of unmatched start log.");
                    System.err.println("Try running with -J-Dorg.netbeans.log.startup.debug=true");
                }
                Error e = new Error("StartLog mismatch: ending '" + action + "' but expecting '" + old + "'; rest of stack: " + actions);
                e.printStackTrace();
                System.exit(1);
            }
            impl.end(action, System.currentTimeMillis());
        }
    }

    public static boolean willLog() {
        return impl.willLog();
    }

    public static void logMeasuredStartupTime(long end) {
        if (impl instanceof PerformanceTestsImpl) {
            ((PerformanceTestsImpl)impl).log("IDE starts t=" + Long.toString(((PerformanceTestsImpl)StartLog.impl).zero) + "\nIDE is running t=" + Long.toString(end) + "\n");
            ((PerformanceTestsImpl)impl).writeLogs();
        }
    }

    static {
        actions = new Stack();
        places = new Stack();
        DEBUG_NESTING = Boolean.getBoolean("org.netbeans.log.startup.debug");
        logProp = System.getProperty("org.netbeans.log.startup");
        logFileProp = System.getProperty("org.netbeans.log.startup.logfile");
        if (logProp == null) {
            impl = new StartImpl();
        } else if ("print".equals(logProp)) {
            impl = new PrintImpl();
        } else if ("tests".equals(logProp)) {
            impl = new PerformanceTestsImpl();
        } else {
            throw new Error("Unknown org.netbeans.log.startup value [" + logProp + "], it should be (print or tests) !");
        }
    }

    private static class PerformanceTestsImpl
    extends StartImpl {
        private StringBuffer logs = new StringBuffer();
        long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PerformanceTestsImpl() {
        }

        @Override
        synchronized void start(String action, long time) {
            this.starts.push(new Long(time));
            this.prog = time;
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " started");
            this.indent += 2;
        }

        @Override
        synchronized void progress(String note, long time) {
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + note + " dT=" + (time - this.prog));
            this.prog = time;
        }

        @Override
        synchronized void end(String action, long time) {
            this.indent -= 2;
            long start = (Long)this.starts.pop();
            this.prog = time;
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " finished, took " + (time - start) + "ms");
        }

        @Override
        boolean willLog() {
            return true;
        }

        private String getIndentString(int indent) {
            if (this.spaces.length < indent) {
                this.spaces = new char[Math.max(this.spaces.length * 2, indent + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, indent);
        }

        synchronized void log(String log) {
            this.logs.append("\n" + log);
        }

        synchronized void writeLogs() {
            if (logFileProp != null) {
                try {
                    File logFile = new File(logFileProp);
                    FileWriter writer = new FileWriter(logFile);
                    writer.write(this.logs.toString());
                    writer.close();
                }
                catch (Exception exc) {
                    System.err.println("EXCEPTION rises during startup logging:");
                    exc.printStackTrace(System.err);
                }
            } else {
                throw new IllegalStateException("You are trying to log startup logs to unexisting file. You have to set property org.netbeans.log.startup.logfile.");
            }
        }
    }

    private static class PrintImpl
    extends StartImpl {
        long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PrintImpl() {
        }

        @Override
        synchronized void start(String action, long time) {
            this.starts.push(new Long(time));
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " started");
            this.indent += 2;
        }

        @Override
        synchronized void progress(String note, long time) {
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + note + " dT=" + (time - this.prog));
            this.prog = time;
        }

        @Override
        synchronized void end(String action, long time) {
            this.indent -= 2;
            long start = (Long)this.starts.pop();
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " finished, took " + (time - start) + "ms");
        }

        @Override
        boolean willLog() {
            return true;
        }

        private String getIndentString(int indent) {
            if (this.spaces.length < indent) {
                this.spaces = new char[Math.max(this.spaces.length * 2, indent + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, indent);
        }
    }

    private static class StartImpl {
        StartImpl() {
        }

        void start(String action, long time) {
        }

        void progress(String note, long time) {
        }

        void end(String action, long time) {
        }

        boolean willLog() {
            return false;
        }
    }
}

