/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.core.startup.CLIOptions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TopLogging {
    public static final String LOG_FILE_NAME = "messages.log";
    private static final boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private PrintStream logPrintStream;
    private static TopLogging topLogging;
    private static final long LOG_MAX_SIZE;
    private static final int LOG_COUNT;

    TopLogging(String logDir) throws IOException {
        topLogging = this;
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        if (logDir == null) {
            this.logPrintStream = System.err;
            this.logPrintStream.println("-------------------------------------------------------------------------------");
            this.logPrintStream.println(">Log Session: " + df.format(date));
            this.logPrintStream.println(">System Info: ");
            try {
                TopLogging.printSystemInfo(this.logPrintStream);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.logPrintStream.flush();
            }
            this.logPrintStream.println("-------------------------------------------------------------------------------");
            this.logPrintStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            return;
        }
        BufferedOutputStream log = null;
        File logFileDir = new File(logDir);
        if (!logFileDir.exists() && !logFileDir.mkdirs()) {
            throw new IOException("Cannot make directory to contain log file");
        }
        File logFile = TopLogging.createLogFile(logFileDir, LOG_FILE_NAME);
        if (logFile.exists() && !logFile.canWrite() || logFile.isDirectory()) {
            throw new IOException("Cannot write to file");
        }
        log = new BufferedOutputStream(new FileOutputStream(logFile.getAbsolutePath(), true));
        PrintStream stderr = System.err;
        this.logPrintStream = new PrintStream((OutputStream)new StreamDemultiplexor(stderr, log), false, "UTF-8");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TopLogging.this.logPrintStream.flush();
                TopLogging.this.logPrintStream.close();
            }
        });
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        this.logPrintStream.println(">Log Session: " + df.format(date));
        this.logPrintStream.println(">System Info: ");
        TopLogging.printSystemInfo(this.logPrintStream);
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        System.setErr(this.logPrintStream);
    }

    private static TopLogging getDefault() {
        if (topLogging == null) {
            try {
                new TopLogging(CLIOptions.getLogDir());
            }
            catch (IOException x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
        }
        return topLogging;
    }

    private static File createLogFile(File parent, String chld) {
        long firstModified = 0L;
        File renameTo = null;
        File retFile = new File(parent, chld);
        if (!retFile.exists() || retFile.length() < LOG_MAX_SIZE) {
            return retFile;
        }
        for (int i = 1; i < LOG_COUNT; ++i) {
            String logName = chld + "." + i;
            File logFile = new File(parent, logName);
            if (!logFile.exists()) {
                renameTo = logFile;
                break;
            }
            long logModif = logFile.lastModified();
            if (firstModified != 0L && logModif >= firstModified || logModif <= 0L) continue;
            firstModified = logModif;
            renameTo = logFile;
        }
        if (renameTo != null) {
            if (renameTo.exists()) {
                renameTo.delete();
            }
            retFile.renameTo(renameTo);
        }
        return retFile;
    }

    public static void printSystemInfo(PrintStream ps) {
        String buildNumber = System.getProperty("netbeans.buildnumber");
        String currentVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)buildNumber);
        ps.println("  Product Version         = " + currentVersion);
        ps.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        ps.println("  Java; VM; Vendor; Home  = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown") + "; " + System.getProperty("java.home", "unknown"));
        ps.print("  System Locale; Encoding = " + Locale.getDefault());
        String branding = NbBundle.getBranding();
        if (branding != null) {
            ps.print(" (" + branding + ")");
        }
        ps.println("; " + System.getProperty("file.encoding", "unknown"));
        ps.println("  Home Dir.; Current Dir. = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        ps.print("  Installation; User Dir. = ");
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ps.print(FileUtil.normalizeFile((File)new File(tok.nextToken())));
                ps.print(File.pathSeparatorChar);
            }
        }
        ps.println(CLIOptions.getHomeDir() + "; " + CLIOptions.getUserDir());
        ps.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        ps.println("  Application Classpath   = " + System.getProperty("java.class.path", "unknown"));
        ps.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
    }

    private static String createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), sb);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), sb);
        return sb.toString();
    }

    private static void findBootJars(String extensions, StringBuffer sb) {
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(entries[i].getPath());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.logPrintStream.flush();
        this.logPrintStream.close();
    }

    public static PrintStream getLogOutputStream() {
        if (System.getProperty("netbeans.user") == null) {
            return System.err;
        }
        return TopLogging.getDefault().logPrintStream;
    }

    static {
        LOG_MAX_SIZE = Long.getLong("org.netbeans.core.TopLogging.LOG_MAX_SIZE", 262144L);
        LOG_COUNT = Integer.getInteger("org.netbeans.core.TopLogging.LOG_COUNT", 3);
    }

    private static final class StreamDemultiplexor
    extends OutputStream
    implements Runnable {
        private RequestProcessor.Task logFlushTask;
        private static final RequestProcessor RP = new RequestProcessor("Flush ide.log");
        private static final Object FLUSH_LOCK = new String("org.netbeans.core.TopLogging.StreamDemultiplexor.FLUSH_LOCK");
        private static final int FLUSH_DELAY = Integer.getInteger("netbeans.logger.flush.delay", 15000);
        private final OutputStream stderr;
        private OutputStream log;

        StreamDemultiplexor(PrintStream stderr, OutputStream log) {
            this.stderr = stderr;
            this.log = log;
        }

        @Override
        public void write(int b) throws IOException {
            this.log.write(b);
            if (!disabledConsole) {
                this.stderr.write(b);
            }
            this.flushLog();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.log.write(b);
            if (!disabledConsole) {
                this.stderr.write(b);
            }
            this.flushLog();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.log.write(b, off, len);
            if (!disabledConsole) {
                this.stderr.write(b, off, len);
            }
            this.flushLog();
        }

        @Override
        public void flush() throws IOException {
            this.log.flush();
            this.stderr.flush();
        }

        @Override
        public void close() throws IOException {
            this.log.close();
            this.stderr.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushLog() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                if (this.logFlushTask == null) {
                    this.logFlushTask = RP.create((Runnable)this);
                    this.logFlushTask.schedule(FLUSH_DELAY);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                try {
                    this.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.logFlushTask = null;
            }
        }
    }
}

