/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import org.netbeans.core.startup.Main;
import org.openide.ErrorManager;

final class TopThreadGroup
extends ThreadGroup
implements Runnable {
    private String[] args;
    private boolean finished;

    public TopThreadGroup(String name, String[] args) {
        super(name);
        this.args = args;
    }

    public TopThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!(e instanceof ThreadDeath || e instanceof IllegalMonitorStateException && "AWT-Selection".equals(t.getName()))) {
            if (e instanceof VirtualMachineError) {
                e.printStackTrace();
            }
            System.err.flush();
            ErrorManager.getDefault().notify(e);
        } else {
            super.uncaughtException(t, e);
        }
    }

    public synchronized void start() throws InterruptedException {
        Thread t = new Thread(this, this, "main");
        t.start();
        while (!this.finished) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Main.start(this.args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ErrorManager.getDefault().notify(t);
        }
        finally {
            TopThreadGroup topThreadGroup = this;
            synchronized (topThreadGroup) {
                this.finished = true;
                this.notify();
            }
        }
    }
}

