/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;

public class BinaryFS
extends FileSystem {
    static final byte[] MAGIC = "org.netbeans.core.projects.cache.BinaryV3".getBytes();
    static final SystemAction[] NO_ACTIONS = new SystemAction[0];
    static final FileObject[] NO_CHILDREN = new FileObject[0];
    String binaryFile;
    ByteBuffer content;
    private FileObject root;
    private List modifications;
    private Date lastModified = new Date();

    public BinaryFS(String binaryFile) throws IOException {
        this.binaryFile = binaryFile;
        RandomAccessFile file = new RandomAccessFile(binaryFile, "r");
        long len = file.length();
        MappedByteBuffer buff = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        file.close();
        byte[] magic = new byte[MAGIC.length];
        buff.get(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IOException("Bad magic header: " + new String(magic));
        }
        long storedLen = buff.getInt();
        if (len != storedLen) {
            throw new IOException("Corrupted image, correct length=" + storedLen);
        }
        int stop = buff.getInt() + 8 + MAGIC.length;
        this.modifications = new ArrayList();
        while (buff.position() < stop) {
            this.modifications.add(BinaryFS.getString(buff));
        }
        this.content = buff.slice().order(ByteOrder.LITTLE_ENDIAN);
        this.root = new BFSFolder("", null, 0);
    }

    public FileObject findResource(String name) {
        String next;
        FileObject fo;
        if (name.length() == 0) {
            return this.root;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        for (fo = this.root; fo != null && st.hasMoreTokens(); fo = fo.getFileObject(next, null)) {
            next = st.nextToken();
        }
        return fo;
    }

    public SystemAction[] getActions() {
        return NO_ACTIONS;
    }

    public String getDisplayName() {
        return "BinaryFS[" + this.binaryFile + "]";
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return true;
    }

    static String getString(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        byte[] arr = new byte[len];
        buffer.get(arr);
        return new String(arr, "UTF-8");
    }

    private class BFSFolder
    extends BFSBase {
        Map childrenMap;

        public BFSFolder(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.childrenMap = Collections.EMPTY_MAP;
        }

        public boolean isData() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException("Is a directory: " + (Object)((Object)this));
        }

        public FileObject[] getChildren() {
            this.initialize();
            return this.childrenMap.values().toArray(NO_CHILDREN);
        }

        public FileObject getFileObject(String name, String ext) {
            this.initialize();
            String fullName = ext == null ? name : name + "." + ext;
            return (FileObject)this.childrenMap.get(fullName);
        }

        @Override
        protected void doInitialize(ByteBuffer sub) throws Exception {
            int files = sub.getInt();
            if (files > 0) {
                this.childrenMap = new HashMap(files * 4 / 3 + 1);
                for (int i = 0; i < files; ++i) {
                    String name = BinaryFS.getString(sub);
                    byte isFolder = sub.get();
                    int off = sub.getInt();
                    this.childrenMap.put(name, isFolder == 0 ? new BFSFile(name, this, off) : new BFSFolder(name, this, off));
                }
            }
        }

        @Override
        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFolder)) {
                return false;
            }
            BFSFolder f = (BFSFolder)_f;
            this.initialize();
            return this.childrenMap.equals(f.childrenMap);
        }
    }

    final class BFSFile
    extends BFSBase {
        private int len;
        private int contentOffset;
        private String uri;
        private long lastModified;

        public BFSFile(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.lastModified = -1L;
        }

        public FileObject[] getChildren() {
            return NO_CHILDREN;
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        private byte[] data() throws IOException {
            if (this.len == -1) {
                throw new IllegalArgumentException();
            }
            byte[] data = new byte[this.len];
            ((ByteBuffer)BinaryFS.this.content.duplicate().position(this.contentOffset)).get(data);
            return data;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            this.initialize();
            try {
                return this.len == -1 ? new URL(this.uri).openConnection().getInputStream() : new ByteArrayInputStream(this.data());
            }
            catch (Exception e) {
                FileNotFoundException x = new FileNotFoundException(e.getMessage());
                ErrorManager.getDefault().annotate((Throwable)x, (Throwable)e);
                throw x;
            }
        }

        public long getSize() {
            this.initialize();
            try {
                return this.len == -1 ? (long)new URL(this.uri).openConnection().getContentLength() : (long)this.len;
            }
            catch (Exception e) {
                System.err.println("exception in getSize() on " + this.name + ": " + e);
                return 0L;
            }
        }

        @Override
        protected void doInitialize(ByteBuffer sub) throws Exception {
            this.len = sub.getInt();
            this.contentOffset = sub.position();
            if (this.len == -1) {
                this.uri = BinaryFS.getString(sub);
            } else {
                sub.position(this.contentOffset + this.len);
            }
            int base = sub.getInt();
            this.lastModified = -10 - base;
        }

        @Override
        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFile)) {
                return false;
            }
            BFSFile f = (BFSFile)_f;
            this.initialize();
            f.initialize();
            if (this.len == -1 && f.len == -1) {
                return this.uri.equals(f.uri);
            }
            if (this.len != -1 && f.len != -1) {
                byte[] fdata;
                byte[] data;
                try {
                    data = this.data();
                    fdata = f.data();
                }
                catch (IOException ioe) {
                    return false;
                }
                if (data.length != fdata.length) {
                    return false;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == fdata[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Date lastModified() {
            this.initialize();
            List list = BinaryFS.this.modifications;
            synchronized (list) {
                if (this.lastModified >= 0L) {
                    return new Date(this.lastModified);
                }
                try {
                    long date;
                    int index = -1;
                    URLConnection conn = null;
                    if (this.len == -1) {
                        conn = new URL(this.uri).openConnection();
                    } else {
                        index = (int)(-this.lastModified) - 10;
                        Object obj = BinaryFS.this.modifications.get(index);
                        if (obj instanceof Date) {
                            return (Date)obj;
                        }
                        conn = new URL((String)obj).openConnection();
                    }
                    if (conn instanceof JarURLConnection) {
                        conn = ((JarURLConnection)conn).getJarFileURL().openConnection();
                    }
                    if (conn != null && (date = conn.getLastModified()) > 0L) {
                        this.lastModified = date;
                        Date d = new Date(date);
                        if (index >= 0) {
                            BinaryFS.this.modifications.set(index, d);
                        }
                        return d;
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return super.lastModified();
        }
    }

    static final class AttrImpl {
        private int index;
        private String value;

        AttrImpl(int type, String textValue) {
            this.index = type;
            this.value = textValue;
        }

        public boolean equals(Object o) {
            if (o instanceof AttrImpl) {
                AttrImpl impl = (AttrImpl)o;
                return this.index == impl.index && this.value.equals(impl.value);
            }
            return false;
        }

        public int hashCode() {
            return 2343 + this.index + this.value.hashCode();
        }

        public Object getValue(FileObject fo, String attrName) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.valueOf(this.value);
                    }
                    case 1: {
                        return Short.valueOf(this.value);
                    }
                    case 2: {
                        return Integer.valueOf(this.value);
                    }
                    case 3: {
                        return Long.valueOf(this.value);
                    }
                    case 4: {
                        return Float.valueOf(this.value);
                    }
                    case 5: {
                        return Double.valueOf(this.value);
                    }
                    case 6: {
                        return Boolean.valueOf(this.value);
                    }
                    case 7: {
                        if (this.value.trim().length() != 1) break;
                        return new Character(this.value.charAt(0));
                    }
                    case 8: {
                        return this.value;
                    }
                    case 9: {
                        return new URL(this.value);
                    }
                    case 10: {
                        return this.methodValue(this.value, fo, attrName);
                    }
                    case 11: {
                        Class cls = this.findClass(this.value);
                        if (SharedClassObject.class.isAssignableFrom(cls)) {
                            return SharedClassObject.findObject((Class)cls, (boolean)true);
                        }
                        return cls.newInstance();
                    }
                    case 12: {
                        return this.decodeValue(this.value);
                    }
                    default: {
                        throw new IllegalStateException("Bad index: " + this.index);
                    }
                }
            }
            catch (Exception exc) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate((Throwable)exc, "value = " + this.value);
                em.notify(1, (Throwable)exc);
            }
            return null;
        }

        private Object methodValue(String method, FileObject fo, String attr) throws Exception {
            int i = method.lastIndexOf(46);
            if (i != -1) {
                String methodName = this.value.substring(i + 1);
                String className = this.value.substring(0, i);
                Class cls = this.findClass(className);
                Object[][] objArray = new Object[][]{null, null, null};
                Method[] methArray = new Method[]{null, null, null};
                Class<?> fParam = fo.getClass();
                Class<?> sParam = attr.getClass();
                Method[] allMethods = cls.getDeclaredMethods();
                for (int j = 0; j < allMethods.length; ++j) {
                    if (!allMethods[j].getName().equals(methodName)) continue;
                    Class<?>[] paramClss = allMethods[j].getParameterTypes();
                    if (paramClss.length == 0) {
                        if (methArray[0] != null) continue;
                        methArray[0] = allMethods[j];
                        objArray[0] = new Object[0];
                        continue;
                    }
                    if (paramClss.length == 2 && methArray[2] == null) {
                        if (paramClss[0].isAssignableFrom(fParam) && paramClss[1].isAssignableFrom(sParam)) {
                            methArray[2] = allMethods[j];
                            objArray[2] = new Object[]{fo, attr};
                            break;
                        }
                        if (!paramClss[0].isAssignableFrom(sParam) || !paramClss[1].isAssignableFrom(fParam)) continue;
                        methArray[2] = allMethods[j];
                        objArray[2] = new Object[]{attr, fo};
                        break;
                    }
                    if (paramClss.length != 1 || methArray[1] != null) continue;
                    if (paramClss[0].isAssignableFrom(fParam)) {
                        methArray[1] = allMethods[j];
                        objArray[1] = new Object[]{fo};
                        continue;
                    }
                    if (!paramClss[0].isAssignableFrom(sParam)) continue;
                    methArray[1] = allMethods[j];
                    objArray[1] = new Object[]{attr};
                }
                for (int k = 2; k >= 0; --k) {
                    if (methArray[k] == null) continue;
                    methArray[k].setAccessible(true);
                    return methArray[k].invoke(null, objArray[k]);
                }
            }
            throw new InstantiationException(this.value);
        }

        private Object decodeValue(String value) throws Exception {
            if (value == null || value.length() == 0) {
                return null;
            }
            byte[] bytes = new byte[value.length() / 2];
            int count = 0;
            for (int i = 0; i < value.length(); i += 2) {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
            return new NbObjectInputStream((InputStream)bis).readObject();
        }

        private Class findClass(String name) throws ClassNotFoundException {
            ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String tname = Utilities.translate((String)name);
            try {
                if (c == null) {
                    return Class.forName(tname);
                }
                return Class.forName(tname, true, c);
            }
            catch (NoClassDefFoundError err) {
                throw new ClassNotFoundException("Cannot read " + name, err);
            }
        }
    }

    private abstract class BFSBase
    extends FileObject {
        private final FileObject parent;
        protected final String name;
        protected final int offset;
        private boolean initialized = false;
        private Map attrs = Collections.EMPTY_MAP;

        public BFSBase(String name, FileObject parent, int offset) {
            this.name = name;
            this.parent = parent;
            this.offset = offset;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof BFSBase)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            BFSBase f = (BFSBase)((Object)o);
            return f.getPath().equals(this.getPath()) && this.specificEquals(f) && this.attributeEquals(f);
        }

        private final boolean attributeEquals(BFSBase base) {
            this.initialize();
            base.initialize();
            return this.attrs.equals(base.attrs);
        }

        public final int hashCode() {
            return this.getPath().hashCode();
        }

        protected abstract boolean specificEquals(BFSBase var1);

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setImportant(boolean b) {
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() {
            return BinaryFS.this;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isValid() {
            return true;
        }

        public Date lastModified() {
            return BinaryFS.this.lastModified;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public String getNameExt() {
            return this.name;
        }

        public Object getAttribute(String attrName) {
            this.initialize();
            AttrImpl attr = (AttrImpl)this.attrs.get(attrName);
            if (attr != null) {
                FileObject topFO = null;
                try {
                    Class<?> mfoClass = Class.forName("org.openide.filesystems.MultiFileObject");
                    Field field = mfoClass.getDeclaredField("attrAskedFileObject");
                    field.setAccessible(true);
                    ThreadLocal attrAskedFileObject = (ThreadLocal)field.get(null);
                    topFO = (FileObject)attrAskedFileObject.get();
                    attrAskedFileObject.set(null);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                return attr.getValue(topFO == null ? this : topFO, attrName);
            }
            return null;
        }

        public Enumeration getAttributes() {
            this.initialize();
            if (this.attrs == null) {
                return Enumerations.empty();
            }
            return Collections.enumeration(this.attrs.keySet());
        }

        protected final void initialize() {
            if (this.initialized) {
                return;
            }
            try {
                ByteBuffer sub = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                int attrCount = sub.getInt();
                if (attrCount > 0) {
                    this.attrs = new HashMap(attrCount * 4 / 3 + 1);
                }
                for (int i = 0; i < attrCount; ++i) {
                    String name = BinaryFS.getString(sub).intern();
                    byte type = sub.get();
                    String value = BinaryFS.getString(sub).intern();
                    this.attrs.put(name, new AttrImpl(type, value));
                }
                this.doInitialize(sub);
            }
            catch (Exception e) {
                System.err.println("exception in initialize() on " + this.name + ": " + e);
            }
            this.initialized = true;
        }

        protected abstract void doInitialize(ByteBuffer var1) throws Exception;
    }
}

